/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.common.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum UrlEnum {
    OPEN(0, "https://", "gw-api.pinduoduo.com", "open.yangkeduo.com", "/api/router"),
    ARK(1, "https://", "ark-api.pinduoduo.com", "open.yangkeduo.com", "/ark/router"),
    FILE(2, "https://", "gw-upload.pinduoduo.com", "open.yangkeduo.com", "/api/upload"),
    MESSAGE(3, "wss://", "message-api.pinduoduo.com", "open.yangkeduo.com", "");

    private Integer code;
    private String protocol;
    private String mainDomain;
    private String backupDomain;
    private String router;
    private volatile boolean currentMain = true;
    private static final Pattern DOMAIN_PATTERN;

    private UrlEnum(Integer code, String protocol, String mainDomain, String backupDomain, String router) {
        this.code = code;
        this.protocol = protocol;
        this.mainDomain = mainDomain;
        this.backupDomain = backupDomain;
        this.router = router;
    }

    public String getUrl() {
        return this.protocol + (this.currentMain ? this.mainDomain : this.backupDomain) + this.router;
    }

    public String getMainDomain() {
        return this.mainDomain;
    }

    public String getBackupDomain() {
        return this.backupDomain;
    }

    public void setCurrentMain(boolean currentMain) {
        this.currentMain = currentMain;
    }

    private String getAnotherUrl(String url) {
        Matcher matcher = DOMAIN_PATTERN.matcher(url);
        if (matcher.matches()) {
            String originProtocol = matcher.group(1);
            String originDomain = matcher.group(2);
            if (this.mainDomain.equals(originDomain)) {
                return originProtocol + this.backupDomain + this.router;
            }
            if (this.backupDomain.equals(originDomain)) {
                return originProtocol + this.mainDomain + this.router;
            }
        }
        return this.protocol + (this.currentMain ? this.backupDomain : this.mainDomain) + this.router;
    }

    static {
        DOMAIN_PATTERN = Pattern.compile("^((?:http|https|ws|wss)://)([^/\\s]+)([^\\s]*)$");
    }
}

