/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.common.logger;

import com.pdd.pop.sdk.common.logger.PopLogger;

public class ConsolePopLogger
implements PopLogger {
    private static final int OFF_LEVEL = 0;
    private static final int ERROR_LEVEL = 2;
    private static final int INFO_LEVEL = 4;
    private static final int DEBUG_LEVEL = 8;
    private static int openLevel = 4;

    public ConsolePopLogger() {
        String level = System.getProperty("pdd.sdk.log.level", "INFO");
        if ("OFF".equals(level.toUpperCase())) {
            openLevel = 0;
        }
        if ("ERROR".equals(level.toUpperCase())) {
            openLevel = 2;
        }
        if ("INFO".equals(level.toUpperCase())) {
            openLevel = 4;
        }
        if ("DEBUG".equals(level.toUpperCase())) {
            openLevel = 8;
        }
    }

    @Override
    public void info(String msg) {
        if (openLevel >= 4) {
            System.out.println(msg);
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (openLevel >= 4) {
            System.out.println(msg);
            t.printStackTrace(System.out);
        }
    }

    @Override
    public void debug(String msg) {
        if (openLevel >= 8) {
            System.out.println(msg);
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (openLevel >= 8) {
            System.out.println(msg);
            t.printStackTrace(System.out);
        }
    }

    @Override
    public void error(String msg) {
        if (openLevel >= 2) {
            System.err.println(msg);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (openLevel >= 2) {
            System.err.println(msg);
            t.printStackTrace(System.err);
        }
    }
}

