/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.common.util;

import com.pdd.pop.sdk.common.util.DigestUtil;
import java.util.Map;
import java.util.TreeMap;

public final class SignUtils {
    public static String buildSignSource(Map<String, String> requestParams, String clientSecret) {
        if (null == requestParams || requestParams.isEmpty()) {
            return "";
        }
        Map<String, String> signSrcMap = requestParams;
        if (!(requestParams instanceof TreeMap)) {
            signSrcMap = new TreeMap<String, String>();
            signSrcMap.putAll(requestParams);
        }
        StringBuilder signSrcBuilder = new StringBuilder().append(clientSecret);
        for (Map.Entry<String, String> entry : signSrcMap.entrySet()) {
            signSrcBuilder.append(entry.getKey()).append(entry.getValue());
        }
        signSrcBuilder.append(clientSecret);
        return signSrcBuilder.toString();
    }

    public static String sign(Map<String, String> requestParams, String clientSecret) {
        return SignUtils.sign(requestParams, clientSecret, "md5");
    }

    public static String sign(Map<String, String> requestParams, String clientSecret, String signMethod) {
        String signSrc = SignUtils.buildSignSource(requestParams, clientSecret);
        return SignUtils.sign(signSrc, signMethod);
    }

    public static String sign(String signSrc, String signMethod) {
        if ("md5".equals(signMethod)) {
            return DigestUtil.md5(signSrc).toUpperCase();
        }
        throw new RuntimeException("Not Support signMethod:" + signMethod);
    }

    public static boolean checkSign(Map<String, String> requestParams, String clientSecret, String sign) {
        return sign != null && sign.equals(SignUtils.sign(requestParams, clientSecret));
    }
}

