/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.http;

import java.util.concurrent.ExecutorService;

public class HttpClientConfig {
    private int connectionTimeoutMillis = 5000;
    private int socketTimeoutMillis = 5000;
    private int connectionRequestTimeout = 1000;
    private static final int MAX_CONNECTION_TIMEOUT_MILLIS = 5000;
    private static final int MAX_SOCKET_TIMEOUT_MILLIS = 5000;
    private static final int MAX_CONNECTION_REQUEST_TIMEOUT = 1000;
    private String proxyHost = null;
    private int proxyPort = 0;
    private boolean proxyIsHttps = false;
    private int maxParallel = 10;
    private long threadKeepAliveTime = 30L;
    private int maxTotal = 50;
    private int defaultMaxPerRoute = 20;
    private ExecutorService executorService = null;

    public static HttpClientConfig getDefault() {
        return new HttpClientConfig();
    }

    public long getThreadKeepAliveTime() {
        return this.threadKeepAliveTime;
    }

    public void setThreadKeepAliveTime(long threadKeepAliveTime) {
        this.threadKeepAliveTime = threadKeepAliveTime;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public void setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        if (connectionTimeoutMillis > 5000) {
            connectionTimeoutMillis = 5000;
        }
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public void setSocketTimeoutMillis(int socketTimeoutMillis) {
        if (socketTimeoutMillis > 5000) {
            socketTimeoutMillis = 5000;
        }
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        if (connectionRequestTimeout > 1000) {
            connectionRequestTimeout = 1000;
        }
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setProxy(String proxyHost, int proxyPort, boolean isHttps) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyIsHttps = isHttps;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean getProxyIsHttps() {
        return this.proxyIsHttps;
    }

    public static final class HttpClientConfigBuilder {
        private int connectionTimeoutMillis = 5000;
        private int socketTimeoutMillis = 5000;
        private int connectionRequestTimeout = 1000;
        private int maxParallel = 10;
        private long threadKeepAliveTime = 30L;
        private int maxTotal = 50;
        private int defaultMaxPerRoute = 20;
        private ExecutorService executorService = null;
        private String proxyHost = null;
        private int proxyPort = 0;
        private boolean proxyIsHttps = false;

        private HttpClientConfigBuilder() {
        }

        public static HttpClientConfigBuilder aHttpClientConfig() {
            return new HttpClientConfigBuilder();
        }

        public HttpClientConfigBuilder withConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public HttpClientConfigBuilder withSocketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public HttpClientConfigBuilder withConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public HttpClientConfigBuilder withMaxParallel(int maxParallel) {
            this.maxParallel = maxParallel;
            return this;
        }

        public HttpClientConfigBuilder withThreadKeepAliveTime(long threadKeepAliveTime) {
            this.threadKeepAliveTime = threadKeepAliveTime;
            return this;
        }

        public HttpClientConfigBuilder withMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public HttpClientConfigBuilder withDefaultMaxPerRoute(int defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
            return this;
        }

        public HttpClientConfigBuilder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public HttpClientConfigBuilder withProxy(String proxyHost, int proxyPort, boolean isHttps) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyIsHttps = isHttps;
            return this;
        }

        public HttpClientConfig build() {
            HttpClientConfig httpClientConfig = new HttpClientConfig();
            httpClientConfig.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
            httpClientConfig.setSocketTimeoutMillis(this.socketTimeoutMillis);
            httpClientConfig.setConnectionRequestTimeout(this.connectionRequestTimeout);
            httpClientConfig.setMaxParallel(this.maxParallel);
            httpClientConfig.setThreadKeepAliveTime(this.threadKeepAliveTime);
            httpClientConfig.setMaxTotal(this.maxTotal);
            httpClientConfig.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
            httpClientConfig.setExecutorService(this.executorService);
            httpClientConfig.setProxy(this.proxyHost, this.proxyPort, this.proxyIsHttps);
            return httpClientConfig;
        }
    }
}

