/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.http;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.sdk.http.FileItem;
import com.pdd.pop.sdk.http.HttpMethod;
import java.util.Map;
import java.util.TreeMap;

public abstract class PopBaseHttpRequest<T> {
    private Long timestamp;
    private String targetClientId;
    private String partnerId;
    private Map<String, String> headers;

    public Long getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = System.currentTimeMillis() / 1000L;
        }
        return this.timestamp;
    }

    public abstract String getVersion();

    public abstract String getDataType();

    public abstract Integer getPlatform();

    public abstract String getType();

    public abstract HttpMethod getHttpMethod();

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public abstract Class<T> getResponseClass();

    public final Map<String, String> getParamsMap() {
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        paramsMap.put("version", this.getVersion());
        paramsMap.put("data_type", this.getDataType());
        paramsMap.put("type", this.getType());
        paramsMap.put("timestamp", this.getTimestamp().toString());
        if (this.targetClientId != null) {
            paramsMap.put("target_client_id", this.targetClientId);
        }
        if (this.partnerId != null) {
            paramsMap.put("partner_id", this.partnerId);
        }
        this.setUserParams(paramsMap);
        return paramsMap;
    }

    public void setTargetClientId(String targetClientId) {
        this.targetClientId = targetClientId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public FileItem getFileItem() {
        return null;
    }

    protected abstract void setUserParams(Map<String, String> var1);

    protected final void setUserParam(Map<String, String> paramMap, String name, Object param) {
        if (param != null) {
            if (this.isPrimaryType(param)) {
                paramMap.put(name, String.valueOf(param));
            } else {
                paramMap.put(name, JsonUtil.transferToJson(param));
            }
        }
    }

    private boolean isPrimaryType(Object param) {
        if (param instanceof Boolean) {
            return true;
        }
        if (param instanceof Byte) {
            return true;
        }
        if (param instanceof Character) {
            return true;
        }
        if (param instanceof Short) {
            return true;
        }
        if (param instanceof Integer) {
            return true;
        }
        if (param instanceof Long) {
            return true;
        }
        if (param instanceof Float) {
            return true;
        }
        if (param instanceof Double) {
            return true;
        }
        return param instanceof String;
    }
}

