/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.http;

import com.pdd.pop.ext.apache.http.impl.client.CloseableHttpClient;
import com.pdd.pop.sdk.common.constant.UrlEnum;
import com.pdd.pop.sdk.common.exception.PopClientException;
import com.pdd.pop.sdk.common.util.CloudInnerUtils;
import com.pdd.pop.sdk.common.util.PreconditionUtil;
import com.pdd.pop.sdk.common.util.StringUtils;
import com.pdd.pop.sdk.http.ClientErrorCode;
import com.pdd.pop.sdk.http.HttpClientConfig;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;
import com.pdd.pop.sdk.http.PopClientInfo;
import com.pdd.pop.sdk.http.client.AbstractPopClient;
import com.pdd.pop.sdk.http.client.ApiPlatformType;
import com.pdd.pop.sdk.http.client.HttpClientFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PopHttpClient
extends AbstractPopClient {
    private ExecutorService executorService;

    public PopHttpClient(String clientId, String clientSecret) {
        this(clientId, clientSecret, HttpClientConfig.getDefault());
    }

    public PopHttpClient(String apiServerUrl, String clientId, String clientSecret) {
        this(clientId, clientSecret, HttpClientConfig.getDefault());
        this.apiServerUrl = apiServerUrl;
    }

    public PopHttpClient(String apiServerUrl, String clientId, String clientSecret, HttpClientConfig config) {
        this(clientId, clientSecret, config);
        this.apiServerUrl = apiServerUrl;
    }

    public PopHttpClient(String clientId, String clientSecret, CloseableHttpClient closeableHttpClient) {
        PreconditionUtil.checkNotNull(closeableHttpClient);
        PreconditionUtil.checkNotNull(clientId);
        PreconditionUtil.checkNotNull(clientSecret);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClient = closeableHttpClient;
        this.executorService = this.getDefaultExecutorService();
    }

    public PopHttpClient(String clientId, String clientSecret, HttpClientConfig config) {
        PreconditionUtil.checkNotNull(clientId);
        PreconditionUtil.checkNotNull(clientSecret);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClient = HttpClientFactory.getHttpClient(config);
        this.executorService = config == null || config.getExecutorService() == null ? this.getDefaultExecutorService() : config.getExecutorService();
    }

    @Override
    public <T extends PopBaseHttpResponse> T syncInvoke(PopBaseHttpRequest<T> request) throws Exception {
        return this.syncInvoke(request, null);
    }

    @Override
    public <T extends PopBaseHttpResponse> T syncInvoke(PopBaseHttpRequest<T> request, String accessToken) throws Exception {
        return this.syncInvoke(request, accessToken, null);
    }

    @Override
    public <T extends PopBaseHttpResponse> T syncInvoke(PopBaseHttpRequest<T> request, String accessToken, PopClientInfo clientInfo) throws Exception {
        return this.syncInvoke(request, accessToken, clientInfo, request.getResponseClass());
    }

    @Override
    public <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> K syncInvokeCustomized(PopBaseHttpRequest<T> request, Class<K> valueType) throws Exception {
        return this.syncInvokeCustomized(request, null, valueType);
    }

    @Override
    public <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> K syncInvokeCustomized(PopBaseHttpRequest<T> request, String accessToken, Class<K> valueType) throws Exception {
        return this.syncInvoke(request, accessToken, null, valueType);
    }

    private <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> K syncInvoke(PopBaseHttpRequest<T> request, String accessToken, PopClientInfo clientInfo, Class<K> valueType) throws Exception {
        String url = this.handleInvokeServiceUrl(request.getPlatform());
        this.handleClientInfo(request, clientInfo);
        switch (request.getHttpMethod()) {
            case GET: {
                return this.syncGet(request, accessToken, url, valueType);
            }
            case POST: {
                return this.syncPost(request, accessToken, url, valueType);
            }
        }
        throw new PopClientException(ClientErrorCode.ILLEGAL_HTTP_METHOD);
    }

    @Override
    public <T extends PopBaseHttpResponse> Future<T> asyncInvoke(PopBaseHttpRequest<T> request) throws Exception {
        return this.asyncInvoke(request, null);
    }

    @Override
    public <T extends PopBaseHttpResponse> Future<T> asyncInvoke(PopBaseHttpRequest<T> request, String accessToken) throws Exception {
        return this.asyncInvoke(request, accessToken, null);
    }

    @Override
    public <T extends PopBaseHttpResponse> Future<T> asyncInvoke(PopBaseHttpRequest<T> request, String accessToken, PopClientInfo clientInfo) throws Exception {
        return this.asyncInvoke(request, accessToken, clientInfo, request.getResponseClass());
    }

    @Override
    public <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> Future<K> asyncInvokeCustomized(PopBaseHttpRequest<T> request, Class<K> valueType) throws Exception {
        return this.asyncInvokeCustomized(request, null, valueType);
    }

    @Override
    public <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> Future<K> asyncInvokeCustomized(PopBaseHttpRequest<T> request, String accessToken, Class<K> valueType) throws Exception {
        return this.asyncInvoke(request, accessToken, null, valueType);
    }

    private <T extends PopBaseHttpResponse, K extends PopBaseHttpResponse> Future<K> asyncInvoke(final PopBaseHttpRequest<T> request, final String accessToken, PopClientInfo clientInfo, final Class<K> valueType) throws Exception {
        PreconditionUtil.checkNotNull(this.executorService);
        this.handleClientInfo(request, clientInfo);
        return this.executorService.submit(new Callable<K>(){

            @Override
            public K call() throws Exception {
                return PopHttpClient.this.syncInvokeCustomized(request, accessToken, valueType);
            }
        });
    }

    private String handleInvokeServiceUrl(Integer platform) {
        String serverUrl = this.apiServerUrl;
        if (StringUtils.isEmpty(serverUrl)) {
            serverUrl = this.getUrlByPlatform(platform);
        }
        if (serverUrl.startsWith("https") && CloudInnerUtils.isInPddCloud()) {
            serverUrl = serverUrl.replaceFirst("https", "http");
        }
        return serverUrl;
    }

    private String getUrlByPlatform(Integer platform) {
        switch (ApiPlatformType.getByCode(platform)) {
            case OPEN: {
                return UrlEnum.OPEN.getUrl();
            }
            case ARK: {
                return UrlEnum.ARK.getUrl();
            }
            case FILE: {
                return UrlEnum.FILE.getUrl();
            }
        }
        return UrlEnum.OPEN.getUrl();
    }

    private <T extends PopBaseHttpResponse> void handleClientInfo(PopBaseHttpRequest<T> request, PopClientInfo clientInfo) {
        if (clientInfo == null) {
            return;
        }
        Map<String, String> headers = request.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
            request.setHeaders(headers);
        }
        if (!StringUtils.isEmpty(clientInfo.getPddClientPlatform())) {
            headers.put("pdd-client-platform", clientInfo.getPddClientPlatform());
        }
        if (!StringUtils.isEmpty(clientInfo.getPddClientIp())) {
            headers.put("pdd-client-ip", clientInfo.getPddClientIp());
        }
        if (!StringUtils.isEmpty(clientInfo.getPddClientUserAgent())) {
            headers.put("pdd-client-user-agent", clientInfo.getPddClientUserAgent());
        }
        if (!StringUtils.isEmpty(clientInfo.getPddId())) {
            headers.put("pdd-id", clientInfo.getPddId());
        }
    }

    public static void enableBackupDomain() {
        DomainSwitcher.manualBackupDomain();
    }

    public static void disableBackupDomain() {
        DomainSwitcher.manualMainDomain();
        DomainSwitcher.disableManual();
    }

    public static void startAutoDomainSwitch() {
        DomainSwitcher.startAutoDomainSwitch();
    }

    public static void stopAutoDomainSwitch() {
        DomainSwitcher.stopAutoDomainSwitch();
    }

    private static class DomainSwitcher {
        private static ScheduledExecutorService SCHEDULE = null;
        private static final int DETECT_PERIOD = 5;
        private static final int DETECT_COUNT = 5;
        private static volatile boolean manual = false;

        private DomainSwitcher() {
        }

        private static synchronized void manualMainDomain() {
            manual = true;
            for (UrlEnum urlEnum : UrlEnum.values()) {
                urlEnum.setCurrentMain(true);
            }
        }

        private static synchronized void manualBackupDomain() {
            manual = true;
            for (UrlEnum urlEnum : UrlEnum.values()) {
                urlEnum.setCurrentMain(false);
            }
        }

        private static synchronized void disableManual() {
            manual = false;
        }

        private static synchronized void startAutoDomainSwitch() {
            if (null != SCHEDULE) {
                return;
            }
            SCHEDULE = Executors.newScheduledThreadPool(1);
            SCHEDULE.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (manual) {
                        return;
                    }
                    for (UrlEnum urlEnum : UrlEnum.values()) {
                        int failCount = 0;
                        for (int i = 0; i < 5; ++i) {
                            try {
                                InetAddress[] allByName = InetAddress.getAllByName(urlEnum.getMainDomain());
                                if (null != allByName && allByName.length > 0) continue;
                                throw new UnknownHostException(urlEnum.getMainDomain());
                            }
                            catch (Exception e) {
                                ++failCount;
                            }
                        }
                        urlEnum.setCurrentMain((double)failCount < 3.0);
                    }
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }

        public static synchronized void stopAutoDomainSwitch() {
            if (null != SCHEDULE) {
                SCHEDULE.shutdownNow();
            }
            SCHEDULE = null;
        }
    }
}

