/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.http.client;

import com.pdd.pop.ext.apache.http.HttpHost;
import com.pdd.pop.ext.apache.http.client.config.RequestConfig;
import com.pdd.pop.ext.apache.http.config.RegistryBuilder;
import com.pdd.pop.ext.apache.http.conn.HttpClientConnectionManager;
import com.pdd.pop.ext.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.pdd.pop.ext.apache.http.conn.ssl.NoopHostnameVerifier;
import com.pdd.pop.ext.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.pdd.pop.ext.apache.http.conn.ssl.TrustStrategy;
import com.pdd.pop.ext.apache.http.impl.client.CloseableHttpClient;
import com.pdd.pop.ext.apache.http.impl.client.HttpClientBuilder;
import com.pdd.pop.ext.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.pdd.pop.ext.apache.http.ssl.SSLContextBuilder;
import com.pdd.pop.sdk.http.HttpClientConfig;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class HttpClientFactory {
    public static HttpClientConnectionManager getConnectionManager(int maxTotal, int maxPerRoute) {
        SSLContext sslContext;
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            sslContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RegistryBuilder<PlainConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        socketFactoryRegistryBuilder.register("http", new PlainConnectionSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)connectionFactory)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        return connectionManager;
    }

    public static CloseableHttpClient getHttpClient(HttpClientConfig httpClientConfig) {
        HttpClientConfig config = httpClientConfig;
        if (null == httpClientConfig) {
            config = HttpClientConfig.getDefault();
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        HttpHost proxy = null;
        if (config.getProxyHost() != null) {
            proxy = new HttpHost(config.getProxyHost(), config.getProxyPort(), config.getProxyIsHttps() ? "https" : "http");
        }
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeoutMillis()).setSocketTimeout(config.getSocketTimeoutMillis()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).setProxy(proxy).build();
        builder.setDefaultRequestConfig(defaultConfig);
        HttpClientConnectionManager connectionManager = HttpClientFactory.getConnectionManager(config.getMaxTotal(), config.getDefaultMaxPerRoute());
        builder.setConnectionManager(connectionManager);
        return builder.build();
    }
}

