/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.http.client;

import com.pdd.pop.ext.apache.http.Header;
import com.pdd.pop.ext.apache.http.HttpEntity;
import com.pdd.pop.ext.apache.http.client.methods.CloseableHttpResponse;
import com.pdd.pop.ext.apache.http.client.methods.HttpPost;
import com.pdd.pop.ext.apache.http.client.methods.HttpUriRequest;
import com.pdd.pop.ext.apache.http.impl.client.CloseableHttpClient;
import com.pdd.pop.ext.apache.http.util.EntityUtils;
import com.pdd.pop.sdk.common.constant.PddCharset;
import com.pdd.pop.sdk.common.exception.PopClientException;
import com.pdd.pop.sdk.common.logger.PopLogger;
import com.pdd.pop.sdk.common.logger.PopLoggerFactory;
import com.pdd.pop.sdk.common.util.IOSupport;
import com.pdd.pop.sdk.http.ClientErrorCode;

public class HttpExecutor {
    protected static final PopLogger logger = PopLoggerFactory.getLogger(HttpExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncExecute(CloseableHttpClient httpClient, HttpUriRequest httpUriRequest) throws Exception {
        String string;
        CloseableHttpResponse httpResponse = null;
        try {
            httpUriRequest.setHeader("Pdd-Sdk-Version", "0.0.6");
            httpUriRequest.setHeader("Pdd-Sdk-Type", "JAVA");
            httpResponse = httpClient.execute(httpUriRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (!this.isSuccess(statusCode)) {
                String requestBody = "";
                if (httpUriRequest instanceof HttpPost) {
                    requestBody = EntityUtils.toString(((HttpPost)httpUriRequest).getEntity(), PddCharset.UTF_8);
                }
                logger.error(String.format("ERROR ! URL : %s ; Header: %s ; requestBody: %s", httpUriRequest.getURI(), this.printHeader(httpUriRequest.getAllHeaders()), requestBody));
                HttpEntity entity = httpResponse.getEntity();
                if (null != entity) {
                    String responseContent = EntityUtils.toString(entity, PddCharset.UTF_8);
                    logger.error(String.format("ERROR responseContent :\n %s ", responseContent));
                }
                throw new PopClientException(ClientErrorCode.HTTP_STATUS_FAIL);
            }
            HttpEntity entity = httpResponse.getEntity();
            String responseContent = EntityUtils.toString(entity, PddCharset.UTF_8);
            EntityUtils.consume(entity);
            string = responseContent;
        }
        catch (Throwable throwable) {
            IOSupport.closeQuietly(httpResponse);
            throw throwable;
        }
        IOSupport.closeQuietly(httpResponse);
        return string;
    }

    private String printHeader(Header[] headers) {
        StringBuilder stringBuffer = new StringBuilder("[");
        if (headers != null) {
            for (Header header : headers) {
                stringBuffer.append(header.getName()).append(":").append(header.getValue()).append(",");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean isSuccess(int statusCode) {
        return 200 <= statusCode && statusCode < 300;
    }
}

