/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.message;

import com.pdd.pop.ext.codahale.metrics.ExponentiallyDecayingReservoir;
import com.pdd.pop.ext.codahale.metrics.Histogram;
import com.pdd.pop.ext.codahale.metrics.Meter;
import com.pdd.pop.ext.glassfish.tyrus.client.ClientManager;
import com.pdd.pop.ext.glassfish.tyrus.container.grizzly.client.GrizzlyClientContainer;
import com.pdd.pop.sdk.common.constant.UrlEnum;
import com.pdd.pop.sdk.common.logger.PopLogger;
import com.pdd.pop.sdk.common.logger.PopLoggerFactory;
import com.pdd.pop.sdk.common.util.CloudInnerUtils;
import com.pdd.pop.sdk.common.util.DigestUtil;
import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.sdk.common.util.StringUtils;
import com.pdd.pop.sdk.message.MessageHandler;
import com.pdd.pop.sdk.message.WsClientEndPoint;
import com.pdd.pop.sdk.message.handler.SessionCloseHandler;
import com.pdd.pop.sdk.message.model.HeartBeatMessage;
import com.pdd.pop.sdk.message.model.ServerMessage;
import com.pdd.pop.sdk.message.model.TimeMetrics;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WsClient {
    private String wsAddress;
    private String clientId;
    private String clientSecret;
    private WebSocketContainer container;
    private Session session;
    private MessageHandler messageHandler;
    private SessionCloseHandler sessionCloseHandler;
    private ThreadPoolExecutor threadPool;
    private int threadCount = Runtime.getRuntime().availableProcessors() * 10;
    private int fetchPeriod = 15;
    private int queueSize = 2000;
    private long heartbeatIntervalMillis;
    private long heartbeatTimeoutMillis;
    private HeartbeatMonitor heartbeatMonitor;
    private WsClientStatus status;
    private static int retryCnt = 0;
    private static final PopLogger logger = PopLoggerFactory.getLogger(WsClient.class);
    private static final Long HEARTBEAT_DEFAULT_INTERVAL_MILLIS = 5000L;
    private static final Long HEARTBEAT_DEFAULT_TIMEOUT_MILLIS = 180000L;
    private static final int RETRY_MAX = 10;

    public WsClient(String clientId, String clientSecret) {
        this("", clientId, clientSecret, null, false);
    }

    public WsClient(String clientId, String clientSecret, MessageHandler messageHandler) {
        this("", clientId, clientSecret, messageHandler, false);
    }

    public WsClient(String clientId, String clientSecret, MessageHandler messageHandler, boolean isMultithreading) {
        this("", clientId, clientSecret, messageHandler, isMultithreading);
    }

    public WsClient(String wsAddress, String clientId, String clientSecret, MessageHandler messageHandler) {
        this(wsAddress, clientId, clientSecret, messageHandler, false);
    }

    public WsClient(String wsAddress, String clientId, String clientSecret, MessageHandler messageHandler, boolean isMultithreading) {
        this.wsAddress = wsAddress;
        if (this.wsAddress != null && this.wsAddress.startsWith("wss") && CloudInnerUtils.isInPddCloud()) {
            this.wsAddress = wsAddress.replaceFirst("wss", "ws");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.messageHandler = messageHandler;
        this.heartbeatIntervalMillis = HEARTBEAT_DEFAULT_INTERVAL_MILLIS;
        this.heartbeatTimeoutMillis = HEARTBEAT_DEFAULT_TIMEOUT_MILLIS;
        if (isMultithreading) {
            this.threadPool = new ThreadPoolExecutor(this.threadCount, this.threadCount, (long)(this.fetchPeriod * 2), TimeUnit.MICROSECONDS, new ArrayBlockingQueue<Runnable>(this.queueSize), new ThreadPoolExecutor.AbortPolicy());
        }
    }

    public void registerSessionCloseHandler(SessionCloseHandler sessionCloseHandler) {
        this.sessionCloseHandler = sessionCloseHandler;
    }

    private void startReconnect() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
        }
        this.heartbeatMonitor = new HeartbeatMonitor(this.heartbeatIntervalMillis, this.heartbeatTimeoutMillis);
        this.heartbeatMonitor.start();
    }

    public synchronized void connect() {
        try {
            if (this.status == WsClientStatus.ONLINE) {
                return;
            }
            this.doConnect();
            this.startReconnect();
            logger.info("webSocket client connected.");
        }
        catch (Exception e) {
            this.closeSession();
            logger.error("webSocket client connect error.", e);
            throw new RuntimeException(e);
        }
    }

    private void closeSession() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            logger.info("wsClient session close.");
        }
        catch (Exception e) {
            logger.error("wsClient session close fail", e);
        }
    }

    private void closeHeartbeatMonitor() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
            logger.info("heartbeatMonitor close.");
        }
    }

    public void close() {
        this.closeSession();
        this.closeHeartbeatMonitor();
        this.status = WsClientStatus.OFFLINE;
        logger.info("wsClient close.");
    }

    public boolean isOnline() {
        return WsClientStatus.ONLINE.equals((Object)this.status);
    }

    protected synchronized void onClose(CloseReason closeReason) {
        this.status = WsClientStatus.OFFLINE;
        if (this.sessionCloseHandler != null) {
            try {
                logger.debug("execute sessionCloseHandler method");
                this.sessionCloseHandler.onClose(this, closeReason);
            }
            catch (Exception e) {
                logger.debug("execute sessionCloseHandler method error", e);
            }
        }
    }

    public HeartbeatMonitor getHeartbeatMonitor() {
        return this.heartbeatMonitor;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    private void doConnect() throws DeploymentException, IOException, URISyntaxException {
        this.container = ClientManager.createClient(GrizzlyClientContainer.class.getName());
        long systemTime = System.currentTimeMillis();
        this.session = this.container.connectToServer(new WsClientEndPoint(this), new URI(this.handleWsAddress() + "/message/" + this.clientId + "/" + systemTime + "/" + DigestUtil.md5Base64Sign32(this.clientId + String.valueOf(systemTime) + this.clientSecret)));
        this.status = WsClientStatus.ONLINE;
    }

    private void reconnect() {
        if (retryCnt++ >= 10) {
            logger.info("reconnect aborted because of reaching max retry times of  10");
            this.heartbeatMonitor.shutdown();
            return;
        }
        try {
            this.doConnect();
            retryCnt = 0;
        }
        catch (Exception e) {
            logger.error("[wsClient reconnect error]", e);
        }
    }

    private String handleWsAddress() {
        String address = this.wsAddress;
        if (StringUtils.isEmpty(address)) {
            address = UrlEnum.MESSAGE.getUrl();
        }
        if (address.startsWith("wss") && CloudInnerUtils.isInPddCloud()) {
            address = address.replaceFirst("wss", "ws");
        }
        return address;
    }

    private static enum WsClientStatus {
        ONLINE,
        OFFLINE;

    }

    class HeartbeatMonitor {
        private Histogram histogram = new Histogram(new ExponentiallyDecayingReservoir());
        private Meter meter = new Meter();
        private final long heartbeatInterval;
        private final long sessionTimeout;
        private volatile long lastHeartbeatSendInMis;
        private volatile long lastHeartbeatRecInMis;
        private MonitorState state;
        private ScheduledExecutorService schedule;
        private static final long SESSION_KEEP_INTERVAL = 30000L;

        public Meter getMeter() {
            return this.meter;
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public void setHistogram(Histogram histogram) {
            this.histogram = histogram;
        }

        public HeartbeatMonitor(long heartbeatInterval, long sessionTimeout) {
            this.heartbeatInterval = heartbeatInterval;
            this.sessionTimeout = sessionTimeout;
            this.lastHeartbeatRecInMis = System.currentTimeMillis();
            this.schedule = Executors.newScheduledThreadPool(1);
            this.state = MonitorState.RUNNING;
        }

        private TimeMetrics getTimeMetrics() {
            TimeMetrics timeMetrics = new TimeMetrics();
            timeMetrics.setCount(this.histogram.getCount());
            timeMetrics.setMax(this.histogram.getSnapshot().getMax());
            timeMetrics.setMean(this.histogram.getSnapshot().getMean());
            timeMetrics.setMedian(this.histogram.getSnapshot().getMedian());
            timeMetrics.setMin(this.histogram.getSnapshot().getMin());
            timeMetrics.setThPercentile75(this.histogram.getSnapshot().get75thPercentile());
            timeMetrics.setThPercentile95(this.histogram.getSnapshot().get95thPercentile());
            timeMetrics.setThPercentile99(this.histogram.getSnapshot().get99thPercentile());
            timeMetrics.setMeanRate(this.meter.getMeanRate());
            timeMetrics.setOneMinuteRate(this.meter.getOneMinuteRate());
            return timeMetrics;
        }

        public void start() {
            this.schedule.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (WsClientStatus.ONLINE.equals((Object)WsClient.this.status) && WsClient.this.session != null && WsClient.this.session.getBasicRemote() != null) {
                            WsClient.this.session.getBasicRemote().sendText(JsonUtil.transferToJson(new HeartBeatMessage(HeartbeatMonitor.this.getTimeMetrics())));
                            HeartbeatMonitor.this.lastHeartbeatSendInMis = System.currentTimeMillis();
                            logger.debug("send heartbeat by client");
                        } else {
                            logger.debug("send heartbeat fail ,reason is session is close");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 0L, this.heartbeatInterval, TimeUnit.MILLISECONDS);
            this.schedule.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Long lastHeardbeatTimediff = System.currentTimeMillis() - HeartbeatMonitor.this.lastHeartbeatRecInMis;
                    if (WsClientStatus.OFFLINE.equals((Object)WsClient.this.status)) {
                        logger.debug("do reconnet , the WsClientStatus is " + (Object)((Object)WsClientStatus.OFFLINE));
                        WsClient.this.reconnect();
                    } else if (lastHeardbeatTimediff > HeartbeatMonitor.this.sessionTimeout) {
                        logger.debug("do reconnet , the last heardbeat time diff is " + lastHeardbeatTimediff);
                        WsClient.this.reconnect();
                    } else {
                        logger.debug("the last heardbeat time diff is " + lastHeardbeatTimediff);
                    }
                }
            }, 0L, 30000L, TimeUnit.MILLISECONDS);
        }

        public void shutdown() {
            this.state = MonitorState.SHUTDOWN;
            this.schedule.shutdown();
        }

        public void rcvHeartbeat(ServerMessage serverMessage) {
            logger.debug(String.format("receive heartbeat from server, server time=%d", serverMessage.getTime()));
            this.lastHeartbeatRecInMis = System.currentTimeMillis();
        }
    }

    private static enum MonitorState {
        RUNNING,
        SHUTDOWN;

    }
}

