/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.sdk.message;

import com.pdd.pop.sdk.common.logger.PopLogger;
import com.pdd.pop.sdk.common.logger.PopLoggerFactory;
import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.sdk.message.WsClient;
import com.pdd.pop.sdk.message.model.AckMessage;
import com.pdd.pop.sdk.message.model.CommandType;
import com.pdd.pop.sdk.message.model.Message;
import com.pdd.pop.sdk.message.model.ServerMessage;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

@ClientEndpoint
public class WsClientEndPoint {
    private static final PopLogger logger = PopLoggerFactory.getLogger(WsClientEndPoint.class);
    private WsClient wsClient;

    public WsClientEndPoint(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    @OnOpen
    public void onOpen(Session session) {
        logger.debug(String.format("webSocket on open,session=%s", session.getId()));
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        logger.info(String.format("webSocket on close, session=%s, reason=%s", session.getId(), closeReason.toString()));
        if (this.wsClient != null) {
            this.wsClient.onClose(closeReason);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        logger.error("webSocket on error, session=" + session.getId() + ", throwable={}", throwable);
    }

    private void dealMessage(ServerMessage serverMessage) {
        try {
            Message messageValue = serverMessage.getMessage();
            this.wsClient.getMessageHandler().onMessage(messageValue);
            this.sendAck(serverMessage);
        }
        catch (Exception e) {
            logger.error("webSocket onMessage error.", e);
            this.sendFailAck(serverMessage, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(String message) {
        block14: {
            try {
                logger.debug("webSocket message received:[" + message + "]");
                final ServerMessage serverMessage = JsonUtil.transferToObj(message, ServerMessage.class);
                if (this.wsClient == null || this.wsClient.getMessageHandler() == null || serverMessage == null) break block14;
                switch (serverMessage.getCommandType()) {
                    case Common: {
                        long dealStart = System.currentTimeMillis();
                        try {
                            if (this.wsClient.getThreadPool() != null) {
                                this.wsClient.getThreadPool().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        WsClientEndPoint.this.dealMessage(serverMessage);
                                    }
                                });
                            } else {
                                this.dealMessage(serverMessage);
                            }
                        }
                        catch (Exception e) {
                            logger.error("webSocket onMessage error.", e);
                            this.sendFailAck(serverMessage, e.getMessage());
                        }
                        finally {
                            this.wsClient.getHeartbeatMonitor().getMeter().mark();
                        }
                        long dealTime = System.currentTimeMillis() - dealStart;
                        if (this.wsClient.getHeartbeatMonitor() == null) break;
                        this.wsClient.getHeartbeatMonitor().getHistogram().update(dealTime);
                        break;
                    }
                    case HeartBeat: {
                        this.rcvHb(serverMessage);
                        break;
                    }
                    case Fail: {
                        this.handleFail(serverMessage);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error("webSocket handle error.", e);
            }
        }
    }

    private void handleFail(ServerMessage serverMessage) {
        logger.error(String.format("[receive fail msg from server],reason=%s", serverMessage.getMessage()));
    }

    private void rcvHb(ServerMessage serverMessage) {
        try {
            this.wsClient.getHeartbeatMonitor().rcvHeartbeat(serverMessage);
        }
        catch (Exception e) {
            logger.error("[heartbeat fail]", e);
        }
    }

    private void sendAck(ServerMessage inMsg) {
        try {
            AckMessage ack = new AckMessage(inMsg.getId(), CommandType.Ack, inMsg.getSendTime(), inMsg.getMessage().getType(), inMsg.getMessage().getMallID(), null);
            this.wsClient.getSession().getAsyncRemote().sendText(JsonUtil.transferToJson(ack));
        }
        catch (Exception e) {
            logger.error("[send ack msg fail]", e);
        }
    }

    private void sendFailAck(ServerMessage inMsg, String failReson) {
        try {
            if (failReson != null && failReson.length() > 1000) {
                failReson = failReson.substring(0, 1000);
            }
            AckMessage ack = new AckMessage(inMsg.getId(), CommandType.Fail, inMsg.getSendTime(), inMsg.getMessage().getType(), inMsg.getMessage().getMallID(), failReson);
            this.wsClient.getSession().getAsyncRemote().sendText(JsonUtil.transferToJson(ack));
        }
        catch (Exception e) {
            logger.error("[send ack msg fail]", e);
        }
    }
}

