/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.pdd.pop.ext.glassfish.grizzly.http.server;

/**
 * Error page generator interface, which is responsible for generating of an
 * error page corresponding to the given response status.
 * 
 * The <tt>ErrorPageGenerator</tt> is mainly used by {@link Response#sendError(int)} and
 * {@link Response#sendError(int, java.lang.String)} methods.
 * 
 * The <tt>ErrorPageGenerator</tt> might be set per
 * 1) {@link HttpServer}: {@link HttpServer#getServerConfiguration()};
 * 2) {@link NetworkListener}: {@link NetworkListener#setDefaultErrorPageGenerator(com.pdd.pop.ext.glassfish.grizzly.http.server.ErrorPageGenerator)};
 * 3) {@link Response}: {@link Response#setErrorPageGenerator(com.pdd.pop.ext.glassfish.grizzly.http.server.ErrorPageGenerator)};
 */
public interface ErrorPageGenerator {
    /**
     * Returns the HTML representation of the error page corresponding to the
     * given HTTP response status.
     * 
     * @param request {@link Request}
     * @param status response status
     * @param reasonPhrase response reason phrase
     * @param description extra description. Might be <tt>null</tt>
     * @param exception {@link Throwable}, that caused the error. Might be <tt>null</tt>
     * @return 
     */
    String generate(final Request request,
                    final int status, final String reasonPhrase,
                    final String description, final Throwable exception);
}
