/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2016 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.pdd.pop.ext.glassfish.tyrus.spi;

import java.nio.ByteBuffer;

/**
 * Read handler provides a way for a transport to pass websocket
 * connection data to tyrus runtime. A transport reads websocket data for an
 * connection and passes the data to tyrus runtime for invoking endpoint.
 * <p>
 * An implementation of this interface is created by tyrus runtime. Once a
 * transport completes a successful upgrade for a connection, the transport
 * can get hold of the handler using {@link Connection#getReadHandler()}.
 */
public interface ReadHandler {

    /**
     * A transport reads websocket data and invokes this method to handover
     * websocket data for a connection to tyrus runtime. The runtime consumes
     * as much data as possible from the byte buffer. If there is some
     * remaining data in the buffer, transport needs pass those bytes in
     * more call (along with more data) in the same byte buffer or in a newer
     * byte buffer.
     *
     * @param data websocket data of a connection.
     */
    void handle(ByteBuffer data);
}
