package com.pdd.pop.sdk.http.api.ark.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.ark.response.PddLogisticsTscOrgBranchAreaCfgPushResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddLogisticsTscOrgBranchAreaCfgPushRequest extends PopBaseHttpRequest<PddLogisticsTscOrgBranchAreaCfgPushResponse> {

    /**
     * 请求体
     */
    @JsonProperty("request")
    private Request request;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 1;
    }

    @Override
    public String getType() {
        return "pdd.logistics.tsc.org.branch.area.cfg.push";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddLogisticsTscOrgBranchAreaCfgPushResponse> getResponseClass() {
        return PddLogisticsTscOrgBranchAreaCfgPushResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "request", request);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public static class Request {

        /**
         * 操作类型：0-删除、1-新增
         */
        @JsonProperty("action")
        private Integer action;

        /**
         * 数据列表：每次最多10条数据
         */
        @JsonProperty("items")
        private List<RequestItemsItem> items;

        /**
         * 操作唯一码：不能超过40个字符
         */
        @JsonProperty("unique_code")
        private String uniqueCode;

        public void setAction(Integer action) {
            this.action = action;
        }

        public void setItems(List<RequestItemsItem> items) {
            this.items = items;
        }

        public void setUniqueCode(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class RequestItemsItem {

        /**
         * 网点编码：不能超过20字符
         */
        @JsonProperty("branch_code")
        private String branchCode;

        /**
         * 网点名字：不能超过50字符
         */
        @JsonProperty("branch_name")
        private String branchName;

        /**
         * 网点完整地址，包括省市区道路门牌号：不能超过200字符
         */
        @JsonProperty("full_address")
        private String fullAddress;

        /**
         * 地图坐标系：0-高德
         */
        @JsonProperty("map_coordinate_system")
        private Integer mapCoordinateSystem;

        /**
         * 数据唯一标识：长度不能超过20
         */
        @JsonProperty("object_id")
        private Long objectId;

        /**
         * 操作人：不能超过15个字符
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 网点围栏不能为空，WKT格式：不能超过500000
         */
        @JsonProperty("shapes")
        private String shapes;

        /**
         * 操作时间戳，默认为0，建议使用该配置修改发生时的 时间戳。如果对同一条记录进行多次编辑，将会以 timestamp最大的为准
         */
        @JsonProperty("timestamp")
        private Long timestamp;

        /**
         * 配送方式：0-不区分，1-仅支持配送，2-仅支持自提
         */
        @JsonProperty("type")
        private Integer type;

        /**
         * 快递公司编码：快递公司附值
         */
        @JsonProperty("wp_code")
        private String wpCode;

        public void setBranchCode(String branchCode) {
            this.branchCode = branchCode;
        }

        public void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public void setFullAddress(String fullAddress) {
            this.fullAddress = fullAddress;
        }

        public void setMapCoordinateSystem(Integer mapCoordinateSystem) {
            this.mapCoordinateSystem = mapCoordinateSystem;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setShapes(String shapes) {
            this.shapes = shapes;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public void setWpCode(String wpCode) {
            this.wpCode = wpCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}