package com.pdd.pop.sdk.http.api.ark.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.ark.response.PddLogisticsTscOrgCenterRouteCfgPushResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddLogisticsTscOrgCenterRouteCfgPushRequest extends PopBaseHttpRequest<PddLogisticsTscOrgCenterRouteCfgPushResponse> {

    /**
     * 请求体
     */
    @JsonProperty("request")
    private Request request;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 1;
    }

    @Override
    public String getType() {
        return "pdd.logistics.tsc.org.center.route.cfg.push";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddLogisticsTscOrgCenterRouteCfgPushResponse> getResponseClass() {
        return PddLogisticsTscOrgCenterRouteCfgPushResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "request", request);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public static class Request {

        /**
         * 操作类型：0-删除、1-新增
         */
        @JsonProperty("action")
        private Integer action;

        /**
         * 数据列表：不能超过10条
         */
        @JsonProperty("items")
        private List<RequestItemsItem> items;

        /**
         * 操作唯一码：不能超过40个字符
         */
        @JsonProperty("unique_code")
        private String uniqueCode;

        public void setAction(Integer action) {
            this.action = action;
        }

        public void setItems(List<RequestItemsItem> items) {
            this.items = items;
        }

        public void setUniqueCode(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class RequestItemsItem {

        /**
         * enableType为2时需要设置, 用英文逗号分割如1,3
         */
        @JsonProperty("days_of_week")
        private String daysOfWeek;

        /**
         * 时间生效类型：0-兜底、1-日期范围、2-星期设置
         */
        @JsonProperty("enable_type")
        private Integer enableType;

        /**
         * enableType为1时需要设置: yyyy-mm-dd
         */
        @JsonProperty("end_date")
        private String endDate;

        /**
         * 数据唯一标识
         */
        @JsonProperty("object_id")
        private Long objectId;

        /**
         * 数据操作人：不能超过15个字符
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 路由编码：不能超过32字符
         */
        @JsonProperty("route_code")
        private String routeCode;

        /**
         * 路由打印值：不能超过128字符
         */
        @JsonProperty("route_print_value")
        private String routePrintValue;

        /**
         * 始发中心编码：不能超过32字符
         */
        @JsonProperty("start_center_code")
        private String startCenterCode;

        /**
         * 始发中心名称：不能超过32字符
         */
        @JsonProperty("start_center_name")
        private String startCenterName;

        /**
         * enableType为1时需要设置: yyyy-mm-dd
         */
        @JsonProperty("start_date")
        private String startDate;

        /**
         * 末端中心编码：不能超过32字符
         */
        @JsonProperty("terminal_center_code")
        private String terminalCenterCode;

        /**
         * 末端中心名称：不能超过32字符
         */
        @JsonProperty("terminal_center_name")
        private String terminalCenterName;

        /**
         * 操作时间戳：默认为0，建议使用该配置修改发生时的 时间戳。如果对同一条记录进行多次编辑，将会以 timestamp最大的为准
         */
        @JsonProperty("timestamp")
        private Long timestamp;

        /**
         * 运输方式编码：0-兜底、1-慢、2-快
         */
        @JsonProperty("transport_type")
        private Integer transportType;

        /**
         * 快递公司编码：快递公司进行赋值
         */
        @JsonProperty("wp_code")
        private String wpCode;

        public void setDaysOfWeek(String daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
        }

        public void setEnableType(Integer enableType) {
            this.enableType = enableType;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setRouteCode(String routeCode) {
            this.routeCode = routeCode;
        }

        public void setRoutePrintValue(String routePrintValue) {
            this.routePrintValue = routePrintValue;
        }

        public void setStartCenterCode(String startCenterCode) {
            this.startCenterCode = startCenterCode;
        }

        public void setStartCenterName(String startCenterName) {
            this.startCenterName = startCenterName;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public void setTerminalCenterCode(String terminalCenterCode) {
            this.terminalCenterCode = terminalCenterCode;
        }

        public void setTerminalCenterName(String terminalCenterName) {
            this.terminalCenterName = terminalCenterName;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public void setTransportType(Integer transportType) {
            this.transportType = transportType;
        }

        public void setWpCode(String wpCode) {
            this.wpCode = wpCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}