package com.pdd.pop.sdk.http.api.ark.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.ark.response.PddLogisticsTscOrgSplitCfgPushResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddLogisticsTscOrgSplitCfgPushRequest extends PopBaseHttpRequest<PddLogisticsTscOrgSplitCfgPushResponse> {

    /**
     * 请求体
     */
    @JsonProperty("request")
    private Request request;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 1;
    }

    @Override
    public String getType() {
        return "pdd.logistics.tsc.org.split.cfg.push";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddLogisticsTscOrgSplitCfgPushResponse> getResponseClass() {
        return PddLogisticsTscOrgSplitCfgPushResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "request", request);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public static class Request {

        /**
         * 操作类型，0-删除 1-新增
         */
        @JsonProperty("action")
        private Integer action;

        /**
         * 数据列表，每次最多10条
         */
        @JsonProperty("items")
        private List<RequestItemsItem> items;

        /**
         * 操作唯一码40个字符
         */
        @JsonProperty("unique_code")
        private String uniqueCode;

        public void setAction(Integer action) {
            this.action = action;
        }

        public void setItems(List<RequestItemsItem> items) {
            this.items = items;
        }

        public void setUniqueCode(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class RequestItemsItem {

        /**
         * 原网点编码
         */
        @JsonProperty("from_branch_code")
        private String fromBranchCode;

        /**
         * 原网点名称
         */
        @JsonProperty("from_branch_name")
        private String fromBranchName;

        /**
         * 原三段码
         */
        @JsonProperty("from_third_seg")
        private String fromThirdSeg;

        /**
         * 批次中的唯一键
         */
        @JsonProperty("object_id")
        private Long objectId;

        /**
         * 操作人不能为空
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 拆分映射类型，0三段码维度，1网点维度
         */
        @JsonProperty("split_type")
        private Integer splitType;

        /**
         * 数据编辑时间
         */
        @JsonProperty("timestamp")
        private Long timestamp;

        /**
         * 新网点编码
         */
        @JsonProperty("to_branch_code")
        private String toBranchCode;

        /**
         * 新网点名称
         */
        @JsonProperty("to_branch_name")
        private String toBranchName;

        /**
         * 新三段码
         */
        @JsonProperty("to_third_seg")
        private String toThirdSeg;

        /**
         * 快递商编码
         */
        @JsonProperty("wp_code")
        private String wpCode;

        public void setFromBranchCode(String fromBranchCode) {
            this.fromBranchCode = fromBranchCode;
        }

        public void setFromBranchName(String fromBranchName) {
            this.fromBranchName = fromBranchName;
        }

        public void setFromThirdSeg(String fromThirdSeg) {
            this.fromThirdSeg = fromThirdSeg;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setSplitType(Integer splitType) {
            this.splitType = splitType;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public void setToBranchCode(String toBranchCode) {
            this.toBranchCode = toBranchCode;
        }

        public void setToBranchName(String toBranchName) {
            this.toBranchName = toBranchName;
        }

        public void setToThirdSeg(String toThirdSeg) {
            this.toThirdSeg = toThirdSeg;
        }

        public void setWpCode(String wpCode) {
            this.wpCode = wpCode;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}