package com.pdd.pop.sdk.http.api.ark.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddLogisticsTscOrgCenterRouteCfgPushResponse extends PopBaseHttpResponse {

    /**
     * 接口返回
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 错误码
         */
        @JsonProperty("error_code")
        private String errorCode;

        /**
         * 错误信息
         */
        @JsonProperty("error_msg")
        private String errorMsg;

        /**
         * 数据处理具体情况，包含成功和失败
         */
        @JsonProperty("result")
        private List<ResponseResultItem> result;

        /**
         * 请求是否处理成功
         */
        @JsonProperty("success")
        private Boolean success;

        public String getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public List<ResponseResultItem> getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResultItem {

        /**
         * 单条数据唯一标识
         */
        @JsonProperty("object_id")
        private Long objectId;

        /**
         * 单条数据失败原因
         */
        @JsonProperty("reason")
        private String reason;

        /**
         * 单条数据是否处理成功
         */
        @JsonProperty("success")
        private Boolean success;

        public Long getObjectId() {
            return objectId;
        }

        public String getReason() {
            return reason;
        }

        public Boolean getSuccess() {
            return success;
        }
    }
}