package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiGoodsQueryPageResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiGoodsQueryPageRequest extends PopBaseHttpRequest<PddAdApiGoodsQueryPageResponse> {

    /**
     * 商品名称
     */
    @JsonProperty("goodsName")
    private String goodsName;

    /**
     * 分页查询，查询第几页
     */
    @JsonProperty("pageNumber")
    private Integer pageNumber;

    /**
     * 分页查询，每页的大小
     */
    @JsonProperty("pageSize")
    private Integer pageSize;

    /**
     * 计划Id
     */
    @JsonProperty("planId")
    private Long planId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.goods.query.page";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiGoodsQueryPageResponse> getResponseClass() {
        return PddAdApiGoodsQueryPageResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "goodsName", goodsName);
        setUserParam(params, "pageNumber", pageNumber);
        setUserParam(params, "pageSize", pageSize);
        setUserParam(params, "planId", planId);
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
}