package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiKeywordCreateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiKeywordCreateRequest extends PopBaseHttpRequest<PddAdApiKeywordCreateResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 关键词创建信息列表
     */
    @JsonProperty("keywordList")
    private List<KeywordListItem> keywordList;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.keyword.create";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiKeywordCreateResponse> getResponseClass() {
        return PddAdApiKeywordCreateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "keywordList", keywordList);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setKeywordList(List<KeywordListItem> keywordList) {
        this.keywordList = keywordList;
    }

    public static class KeywordListItem {

        /**
         * 关键词出价
         */
        @JsonProperty("bid")
        private Long bid;

        /**
         * 关键词溢价比例。万分比。
         */
        @JsonProperty("premiumRate")
        private Long premiumRate;

        /**
         * 关键词
         */
        @JsonProperty("word")
        private String word;

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public void setPremiumRate(Long premiumRate) {
            this.premiumRate = premiumRate;
        }

        public void setWord(String word) {
            this.word = word;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}