package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiKeywordRelevanceGetResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiKeywordRelevanceGetRequest extends PopBaseHttpRequest<PddAdApiKeywordRelevanceGetResponse> {

    /**
     * 商品Id
     */
    @JsonProperty("goodsId")
    private Long goodsId;

    /**
     * 关键词数组
     */
    @JsonProperty("words")
    private List<String> words;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.keyword.relevance.get";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiKeywordRelevanceGetResponse> getResponseClass() {
        return PddAdApiKeywordRelevanceGetResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "goodsId", goodsId);
        setUserParam(params, "words", words);
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public void setWords(List<String> words) {
        this.words = words;
    }
}