package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiKeywordUpdateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiKeywordUpdateRequest extends PopBaseHttpRequest<PddAdApiKeywordUpdateResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 关键词列表
     */
    @JsonProperty("keywords")
    private List<KeywordsItem> keywords;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.keyword.update";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiKeywordUpdateResponse> getResponseClass() {
        return PddAdApiKeywordUpdateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "keywords", keywords);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setKeywords(List<KeywordsItem> keywords) {
        this.keywords = keywords;
    }

    public static class KeywordsItem {

        /**
         * 关键词出价
         */
        @JsonProperty("bid")
        private Long bid;

        /**
         * 关键词Id
         */
        @JsonProperty("keywordId")
        private Long keywordId;

        /**
         * 关键词溢价比例。万分比。
         */
        @JsonProperty("premiumRate")
        private Long premiumRate;

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public void setKeywordId(Long keywordId) {
            this.keywordId = keywordId;
        }

        public void setPremiumRate(Long premiumRate) {
            this.premiumRate = premiumRate;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}