package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanCreateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiPlanCreateRequest extends PopBaseHttpRequest<PddAdApiPlanCreateResponse> {

    /**
     * 计划创建信息
     */
    @JsonProperty("adPlanCreateMessage")
    private AdPlanCreateMessage adPlanCreateMessage;

    /**
     * 单元创建信息列表
     */
    @JsonProperty("adUnitCreateComplexMessageList")
    private List<AdUnitCreateComplexMessageListItem> adUnitCreateComplexMessageList;

    /**
     * 推广策略。1：自定义推广，3：展示ocpc智能推广。不传时表示自定义推广
     */
    @JsonProperty("planStrategy")
    private Integer planStrategy;

    /**
     * 场景类型。0表示搜索，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.create";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanCreateResponse> getResponseClass() {
        return PddAdApiPlanCreateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adPlanCreateMessage", adPlanCreateMessage);
        setUserParam(params, "adUnitCreateComplexMessageList", adUnitCreateComplexMessageList);
        setUserParam(params, "planStrategy", planStrategy);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setAdPlanCreateMessage(AdPlanCreateMessage adPlanCreateMessage) {
        this.adPlanCreateMessage = adPlanCreateMessage;
    }

    public void setAdUnitCreateComplexMessageList(List<AdUnitCreateComplexMessageListItem> adUnitCreateComplexMessageList) {
        this.adUnitCreateComplexMessageList = adUnitCreateComplexMessageList;
    }

    public void setPlanStrategy(Integer planStrategy) {
        this.planStrategy = planStrategy;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }

    public static class AdPlanCreateMessage {

        /**
         * 单日消耗
         */
        @JsonProperty("maxCost")
        private Long maxCost;

        /**
         * 分时折扣
         */
        @JsonProperty("planDiscount")
        private AdPlanCreateMessagePlanDiscount planDiscount;

        /**
         * 计划名称
         */
        @JsonProperty("planName")
        private String planName;

        public void setMaxCost(Long maxCost) {
            this.maxCost = maxCost;
        }

        public void setPlanDiscount(AdPlanCreateMessagePlanDiscount planDiscount) {
            this.planDiscount = planDiscount;
        }

        public void setPlanName(String planName) {
            this.planName = planName;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdPlanCreateMessagePlanDiscount {

        /**
         * 分时折扣配置
         */
        @JsonProperty("discounts")
        private List<AdPlanCreateMessagePlanDiscountDiscountsItem> discounts;

        public void setDiscounts(List<AdPlanCreateMessagePlanDiscountDiscountsItem> discounts) {
            this.discounts = discounts;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdPlanCreateMessagePlanDiscountDiscountsItem {

        /**
         * 小时。0-23分别表示第1个小时到第24个小时。
         */
        @JsonProperty("index")
        private Integer index;

        /**
         * 折扣比例。千分比（即rate等于1000表示比例100%）。
         */
        @JsonProperty("rate")
        private Integer rate;

        public void setIndex(Integer index) {
            this.index = index;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItem {

        /**
         * 创意创建信息列表
         */
        @JsonProperty("adCreativeCreateMessagesList")
        private List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItem> adCreativeCreateMessagesList;

        /**
         * 关键词创建列表
         */
        @JsonProperty("adKeywordCreateMessageList")
        private List<AdUnitCreateComplexMessageListItemAdKeywordCreateMessageListItem> adKeywordCreateMessageList;

        /**
         * 智能词包相关信息
         */
        @JsonProperty("adKeywordSetMessage")
        private AdUnitCreateComplexMessageListItemAdKeywordSetMessage adKeywordSetMessage;

        /**
         * 商品创建信息
         */
        @JsonProperty("adProductCreateMessage")
        private AdUnitCreateComplexMessageListItemAdProductCreateMessage adProductCreateMessage;

        /**
         * 单元创建信息
         */
        @JsonProperty("adUnitCreateMessage")
        private AdUnitCreateComplexMessageListItemAdUnitCreateMessage adUnitCreateMessage;

        /**
         * 人群定向创建信息列表
         */
        @JsonProperty("audienceBidCreateMessageList")
        private List<AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItem> audienceBidCreateMessageList;

        /**
         * 资源位定向创建信息列表。仅支持展示广告。
         */
        @JsonProperty("locationBidCreateMessageList")
        private List<AdUnitCreateComplexMessageListItemLocationBidCreateMessageListItem> locationBidCreateMessageList;

        /**
         * 智能创意创建信息
         */
        @JsonProperty("smartCreativeCreateMessage")
        private AdUnitCreateComplexMessageListItemSmartCreativeCreateMessage smartCreativeCreateMessage;

        public void setAdCreativeCreateMessagesList(List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItem> adCreativeCreateMessagesList) {
            this.adCreativeCreateMessagesList = adCreativeCreateMessagesList;
        }

        public void setAdKeywordCreateMessageList(List<AdUnitCreateComplexMessageListItemAdKeywordCreateMessageListItem> adKeywordCreateMessageList) {
            this.adKeywordCreateMessageList = adKeywordCreateMessageList;
        }

        public void setAdKeywordSetMessage(AdUnitCreateComplexMessageListItemAdKeywordSetMessage adKeywordSetMessage) {
            this.adKeywordSetMessage = adKeywordSetMessage;
        }

        public void setAdProductCreateMessage(AdUnitCreateComplexMessageListItemAdProductCreateMessage adProductCreateMessage) {
            this.adProductCreateMessage = adProductCreateMessage;
        }

        public void setAdUnitCreateMessage(AdUnitCreateComplexMessageListItemAdUnitCreateMessage adUnitCreateMessage) {
            this.adUnitCreateMessage = adUnitCreateMessage;
        }

        public void setAudienceBidCreateMessageList(List<AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItem> audienceBidCreateMessageList) {
            this.audienceBidCreateMessageList = audienceBidCreateMessageList;
        }

        public void setLocationBidCreateMessageList(List<AdUnitCreateComplexMessageListItemLocationBidCreateMessageListItem> locationBidCreateMessageList) {
            this.locationBidCreateMessageList = locationBidCreateMessageList;
        }

        public void setSmartCreativeCreateMessage(AdUnitCreateComplexMessageListItemSmartCreativeCreateMessage smartCreativeCreateMessage) {
            this.smartCreativeCreateMessage = smartCreativeCreateMessage;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItem {

        /**
         * 创意图片列表
         */
        @JsonProperty("adImageVOList")
        private List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdImageVOListItem> adImageVOList;

        /**
         * 创意标题列表
         */
        @JsonProperty("adTextVOList")
        private List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdTextVOListItem> adTextVOList;

        /**
         * 创意规格，6：商品轮播图，7：商品长图，其余规格暂不支持
         */
        @JsonProperty("creativeSpecificationId")
        private Long creativeSpecificationId;

        public void setAdImageVOList(List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdImageVOListItem> adImageVOList) {
            this.adImageVOList = adImageVOList;
        }

        public void setAdTextVOList(List<AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdTextVOListItem> adTextVOList) {
            this.adTextVOList = adTextVOList;
        }

        public void setCreativeSpecificationId(Long creativeSpecificationId) {
            this.creativeSpecificationId = creativeSpecificationId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdImageVOListItem {

        /**
         * 图片链接，可用图片参考以下接口返回：pdd.ad.api.goods.query.gallery.images（轮播图），pdd.ad.api.goods.query.long.images（长图）
         */
        @JsonProperty("imageUrl")
        private String imageUrl;

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdCreativeCreateMessagesListItemAdTextVOListItem {

        /**
         * 标题
         */
        @JsonProperty("text")
        private String text;

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdKeywordCreateMessageListItem {

        /**
         * 关键词出价
         */
        @JsonProperty("bid")
        private Long bid;

        /**
         * 关键词溢价比例。万分比
         */
        @JsonProperty("premiumRate")
        private Long premiumRate;

        /**
         * 关键词
         */
        @JsonProperty("word")
        private String word;

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public void setPremiumRate(Long premiumRate) {
            this.premiumRate = premiumRate;
        }

        public void setWord(String word) {
            this.word = word;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdKeywordSetMessage {

        /**
         * 词包出价。出价需在[0.10, 99.00]之间。
         */
        @JsonProperty("keywordSetBid")
        private Long keywordSetBid;

        public void setKeywordSetBid(Long keywordSetBid) {
            this.keywordSetBid = keywordSetBid;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdProductCreateMessage {

        /**
         * 商品Id
         */
        @JsonProperty("goodsId")
        private Long goodsId;

        public void setGoodsId(Long goodsId) {
            this.goodsId = goodsId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdUnitCreateMessage {

        /**
         * 推广单元名称
         */
        @JsonProperty("adName")
        private String adName;

        /**
         * 基础出价。单位厘。
         */
        @JsonProperty("bid")
        private Long bid;

        /**
         * 智能优化广告相关。当单元使用自定义推广时，不要使用该字段。
         */
        @JsonProperty("optimizationMessage")
        private AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessage optimizationMessage;

        public void setAdName(String adName) {
            this.adName = adName;
        }

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public void setOptimizationMessage(AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessage optimizationMessage) {
            this.optimizationMessage = optimizationMessage;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessage {

        /**
         * 数据积累期出价。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("accumulationBid")
        private Long accumulationBid;

        /**
         * 智能投放期出价。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 优化目标。0表示不优化。1表示优化ROI，2表示优化转化成本.自定义单元时，该值必传0；当单元使用展示自动调价功能(ECPC)时，该值必须传1；当单元使用展示OCPC功能（plan_strategy=3）时，该值必须传2。
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        /**
         * 优化方式。0表示不优化，1表示ECPC，2表示OCPC。当单元使用ECPC时，该值必须传1；当使用OCPC时，该值必须传2。
         */
        @JsonProperty("optimizationMethod")
        private Integer optimizationMethod;

        /**
         * 可选优化出价列表。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("optionalOptimizationBidMessageList")
        private List<AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessageOptionalOptimizationBidMessageListItem> optionalOptimizationBidMessageList;

        public void setAccumulationBid(Long accumulationBid) {
            this.accumulationBid = accumulationBid;
        }

        public void setOptimizationBid(Long optimizationBid) {
            this.optimizationBid = optimizationBid;
        }

        public void setOptimizationGoal(Integer optimizationGoal) {
            this.optimizationGoal = optimizationGoal;
        }

        public void setOptimizationMethod(Integer optimizationMethod) {
            this.optimizationMethod = optimizationMethod;
        }

        public void setOptionalOptimizationBidMessageList(List<AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessageOptionalOptimizationBidMessageListItem> optionalOptimizationBidMessageList) {
            this.optionalOptimizationBidMessageList = optionalOptimizationBidMessageList;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAdUnitCreateMessageOptimizationMessageOptionalOptimizationBidMessageListItem {

        /**
         * 可选优化出价价格
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 可选优化出价目标。3表示优化店铺关注，4表示优化商品收藏，5表示优化询单
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        public void setOptimizationBid(Long optimizationBid) {
            this.optimizationBid = optimizationBid;
        }

        public void setOptimizationGoal(Integer optimizationGoal) {
            this.optimizationGoal = optimizationGoal;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItem {

        /**
         * 定向创建信息
         */
        @JsonProperty("adTargetingCreateMessage")
        private AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessage adTargetingCreateMessage;

        /**
         * 人群定向类型，可用枚举值，参考接口：pdd.ad.api.unit.bid.query.base.target.profile
         */
        @JsonProperty("bidReferenceId")
        private Long bidReferenceId;

        /**
         * 出价，万分比
         */
        @JsonProperty("bidValue")
        private Long bidValue;

        /**
         * 人群定向二级Id。默认为0。
         */
        @JsonProperty("subBidReferenceId")
        private Long subBidReferenceId;

        public void setAdTargetingCreateMessage(AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessage adTargetingCreateMessage) {
            this.adTargetingCreateMessage = adTargetingCreateMessage;
        }

        public void setBidReferenceId(Long bidReferenceId) {
            this.bidReferenceId = bidReferenceId;
        }

        public void setBidValue(Long bidValue) {
            this.bidValue = bidValue;
        }

        public void setSubBidReferenceId(Long subBidReferenceId) {
            this.subBidReferenceId = subBidReferenceId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessage {

        /**
         * 定向集合
         */
        @JsonProperty("adTargetingSet")
        private AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSet adTargetingSet;

        /**
         * 定向名称
         */
        @JsonProperty("targetingName")
        private String targetingName;

        public void setAdTargetingSet(AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSet adTargetingSet) {
            this.adTargetingSet = adTargetingSet;
        }

        public void setTargetingName(String targetingName) {
            this.targetingName = targetingName;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSet {

        /**
         * 地域定向
         */
        @JsonProperty("areaStruct")
        private AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSetAreaStruct areaStruct;

        public void setAreaStruct(AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSetAreaStruct areaStruct) {
            this.areaStruct = areaStruct;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemAudienceBidCreateMessageListItemAdTargetingCreateMessageAdTargetingSetAreaStruct {

        /**
         * 地域Id列表。具体地域Id编码参见接口返回：pdd.ad.api.unit.bid.query.targeting.tag.list
         */
        @JsonProperty("areaIds")
        private List<Integer> areaIds;

        public void setAreaIds(List<Integer> areaIds) {
            this.areaIds = areaIds;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemLocationBidCreateMessageListItem {

        /**
         * 资源位定向类型。可取值参考接口：pdd.ad.api.unit.bid.query.available.location
         */
        @JsonProperty("bidReferenceId")
        private Long bidReferenceId;

        /**
         * 出价，万分比
         */
        @JsonProperty("bidValue")
        private Long bidValue;

        public void setBidReferenceId(Long bidReferenceId) {
            this.bidReferenceId = bidReferenceId;
        }

        public void setBidValue(Long bidValue) {
            this.bidValue = bidValue;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitCreateComplexMessageListItemSmartCreativeCreateMessage {

        /**
         * 智能创意流量分配比例
         */
        @JsonProperty("creativeFlowRate")
        private Integer creativeFlowRate;

        /**
         * 是否启用智能创意标识
         */
        @JsonProperty("enableSmartCreative")
        private Integer enableSmartCreative;

        /**
         * 智能创意标题
         */
        @JsonProperty("smartCreativeTitle")
        private String smartCreativeTitle;

        public void setCreativeFlowRate(Integer creativeFlowRate) {
            this.creativeFlowRate = creativeFlowRate;
        }

        public void setEnableSmartCreative(Integer enableSmartCreative) {
            this.enableSmartCreative = enableSmartCreative;
        }

        public void setSmartCreativeTitle(String smartCreativeTitle) {
            this.smartCreativeTitle = smartCreativeTitle;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}