package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanQueryCanCreateAdPlanResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiPlanQueryCanCreateAdPlanRequest extends PopBaseHttpRequest<PddAdApiPlanQueryCanCreateAdPlanResponse> {

    /**
     * 单元名称
     */
    @JsonProperty("planName")
    private String planName;

    /**
     * 场景类型。0表示搜索，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.query.can.create.ad.plan";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanQueryCanCreateAdPlanResponse> getResponseClass() {
        return PddAdApiPlanQueryCanCreateAdPlanResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "planName", planName);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }
}