package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanUpdateDataOperateStatusResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiPlanUpdateDataOperateStatusRequest extends PopBaseHttpRequest<PddAdApiPlanUpdateDataOperateStatusResponse> {

    /**
     * 数据操作状态。1表示开启，2表示暂停。
     */
    @JsonProperty("dataOperateStatus")
    private Integer dataOperateStatus;

    /**
     * 广告计划Id列表
     */
    @JsonProperty("planIds")
    private List<Long> planIds;

    /**
     * 场景类型。0表示搜索，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.update.data.operate.status";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanUpdateDataOperateStatusResponse> getResponseClass() {
        return PddAdApiPlanUpdateDataOperateStatusResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "dataOperateStatus", dataOperateStatus);
        setUserParam(params, "planIds", planIds);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setDataOperateStatus(Integer dataOperateStatus) {
        this.dataOperateStatus = dataOperateStatus;
    }

    public void setPlanIds(List<Long> planIds) {
        this.planIds = planIds;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }
}