package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanUpdateMaxCostResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiPlanUpdateMaxCostRequest extends PopBaseHttpRequest<PddAdApiPlanUpdateMaxCostResponse> {

    /**
     * 日消耗上限。单位厘。
     */
    @JsonProperty("maxCost")
    private Long maxCost;

    /**
     * 广告计划Id
     */
    @JsonProperty("planId")
    private Long planId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.update.max.cost";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanUpdateMaxCostResponse> getResponseClass() {
        return PddAdApiPlanUpdateMaxCostResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "maxCost", maxCost);
        setUserParam(params, "planId", planId);
    }

    public void setMaxCost(Long maxCost) {
        this.maxCost = maxCost;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
}