package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanUpdatePlanDiscountResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiPlanUpdatePlanDiscountRequest extends PopBaseHttpRequest<PddAdApiPlanUpdatePlanDiscountResponse> {

    /**
     * 分时折扣
     */
    @JsonProperty("planDiscount")
    private PlanDiscount planDiscount;

    /**
     * 广告计划Id
     */
    @JsonProperty("planId")
    private Long planId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.update.plan.discount";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanUpdatePlanDiscountResponse> getResponseClass() {
        return PddAdApiPlanUpdatePlanDiscountResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "planDiscount", planDiscount);
        setUserParam(params, "planId", planId);
    }

    public void setPlanDiscount(PlanDiscount planDiscount) {
        this.planDiscount = planDiscount;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public static class PlanDiscount {

        /**
         * 分时折扣配置列表
         */
        @JsonProperty("discounts")
        private List<PlanDiscountDiscountsItem> discounts;

        public void setDiscounts(List<PlanDiscountDiscountsItem> discounts) {
            this.discounts = discounts;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class PlanDiscountDiscountsItem {

        /**
         * 小时。0-23分别表示第1个小时到第24个小时。
         */
        @JsonProperty("index")
        private Integer index;

        /**
         * 折扣比例。千分比（即rate等于1000表示比例100%）。
         */
        @JsonProperty("rate")
        private Integer rate;

        public void setIndex(Integer index) {
            this.index = index;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}