package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanUpdatePlanNameResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiPlanUpdatePlanNameRequest extends PopBaseHttpRequest<PddAdApiPlanUpdatePlanNameResponse> {

    /**
     * 广告计划Id
     */
    @JsonProperty("planId")
    private Long planId;

    /**
     * 计划名称
     */
    @JsonProperty("planName")
    private String planName;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.update.plan.name";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanUpdatePlanNameResponse> getResponseClass() {
        return PddAdApiPlanUpdatePlanNameResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "planId", planId);
        setUserParam(params, "planName", planName);
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
}