package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiPlanUpdatePlanToOcpcResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiPlanUpdatePlanToOcpcRequest extends PopBaseHttpRequest<PddAdApiPlanUpdatePlanToOcpcResponse> {

    /**
     * 单元OCPC信息列表
     */
    @JsonProperty("adUnitUpdateOcpcMessageList")
    private List<AdUnitUpdateOcpcMessageListItem> adUnitUpdateOcpcMessageList;

    /**
     * 广告计划Id
     */
    @JsonProperty("planId")
    private Long planId;

    /**
     * 场景类型。0表示搜索。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.plan.update.plan.to.ocpc";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiPlanUpdatePlanToOcpcResponse> getResponseClass() {
        return PddAdApiPlanUpdatePlanToOcpcResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adUnitUpdateOcpcMessageList", adUnitUpdateOcpcMessageList);
        setUserParam(params, "planId", planId);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setAdUnitUpdateOcpcMessageList(List<AdUnitUpdateOcpcMessageListItem> adUnitUpdateOcpcMessageList) {
        this.adUnitUpdateOcpcMessageList = adUnitUpdateOcpcMessageList;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }

    public static class AdUnitUpdateOcpcMessageListItem {

        /**
         * 广告单元Id
         */
        @JsonProperty("adId")
        private Long adId;

        /**
         * OCPC信息
         */
        @JsonProperty("optimizationMessage")
        private AdUnitUpdateOcpcMessageListItemOptimizationMessage optimizationMessage;

        public void setAdId(Long adId) {
            this.adId = adId;
        }

        public void setOptimizationMessage(AdUnitUpdateOcpcMessageListItemOptimizationMessage optimizationMessage) {
            this.optimizationMessage = optimizationMessage;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitUpdateOcpcMessageListItemOptimizationMessage {

        /**
         * 智能投放期出价
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 优化目标。单元使用OCPC功能时，该值必须传2。
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        /**
         * 优化方式。当使用OCPC时，该值必须传2。
         */
        @JsonProperty("optimizationMethod")
        private Integer optimizationMethod;

        public void setOptimizationBid(Long optimizationBid) {
            this.optimizationBid = optimizationBid;
        }

        public void setOptimizationGoal(Integer optimizationGoal) {
            this.optimizationGoal = optimizationGoal;
        }

        public void setOptimizationMethod(Integer optimizationMethod) {
            this.optimizationMethod = optimizationMethod;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}