package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiReportActivityReportQueryResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiReportActivityReportQueryRequest extends PopBaseHttpRequest<PddAdApiReportActivityReportQueryResponse> {

    /**
     * 结束日期的字符串，格式类似'2020-02-02'
     */
    @JsonProperty("endDateString")
    private String endDateString;

    /**
     * 场景类型：3联合推广。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    /**
     * 开始日期的字符串，格式类似'2020-02-02'，如果查询今日，startDateString和endDateString传今日的字符串，如果查询历史，startDateString和endDateString分别传开始和结束字符串，不能跨今日和历史查询
     */
    @JsonProperty("startDateString")
    private String startDateString;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.report.activity.report.query";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiReportActivityReportQueryResponse> getResponseClass() {
        return PddAdApiReportActivityReportQueryResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "endDateString", endDateString);
        setUserParam(params, "scenesType", scenesType);
        setUserParam(params, "startDateString", startDateString);
    }

    public void setEndDateString(String endDateString) {
        this.endDateString = endDateString;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }

    public void setStartDateString(String startDateString) {
        this.startDateString = startDateString;
    }
}