package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiReportDailyReportQueryResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiReportDailyReportQueryRequest extends PopBaseHttpRequest<PddAdApiReportDailyReportQueryResponse> {

    /**
     * 结束日期的字符串，格式类似'2020-02-02'，当前支持查询90天内数据
     */
    @JsonProperty("endDateString")
    private String endDateString;

    /**
     * 各维度查询的主体id，查询计划维度传计划id，查询单元维度传单元id，查询关键词维度传关键词id，查询创意传创意id，查询广告主维度，资源位和定向维度不用传此参数
     */
    @JsonProperty("entityId")
    private Long entityId;

    /**
     * 额外的查询条件，查询关键词，创意维度的的时候要在此传单元id(adId)的信息，查询资源位的时候要传单元id(adId）和资源位类型(bidReferenceId),查询定向维度要传单元id(adId),定向类型(bidReferenceId)，如果是查二级定向，需要传二级定向id(subBidReferenceId)
     */
    @JsonProperty("externalParamMap")
    private Map<String, String> externalParamMap;

    /**
     * 查询维度，0-广告主，1-计划，2-单元，3-定向，4-创意，5-资源位，6-关键词
     */
    @JsonProperty("queryDimensionType")
    private Integer queryDimensionType;

    /**
     * 场景类型。0表示搜索，1明星店铺，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    /**
     * 开始日期的字符串，格式类似'2020-02-02'，如果查询今日，startDateString和endDateString传今日的字符串，如果查询历史，startDateString和endDateString分别传开始和结束字符串，不能跨今日和历史查询
     */
    @JsonProperty("startDateString")
    private String startDateString;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.report.daily.report.query";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiReportDailyReportQueryResponse> getResponseClass() {
        return PddAdApiReportDailyReportQueryResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "endDateString", endDateString);
        setUserParam(params, "entityId", entityId);
        setUserParam(params, "externalParamMap", externalParamMap);
        setUserParam(params, "queryDimensionType", queryDimensionType);
        setUserParam(params, "scenesType", scenesType);
        setUserParam(params, "startDateString", startDateString);
    }

    public void setEndDateString(String endDateString) {
        this.endDateString = endDateString;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setExternalParamMap(Map<String, String> externalParamMap) {
        this.externalParamMap = externalParamMap;
    }

    public void setQueryDimensionType(Integer queryDimensionType) {
        this.queryDimensionType = queryDimensionType;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }

    public void setStartDateString(String startDateString) {
        this.startDateString = startDateString;
    }
}