package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiReportEntityReportQueryResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiReportEntityReportQueryRequest extends PopBaseHttpRequest<PddAdApiReportEntityReportQueryResponse> {

    /**
     * 结束日期的字符串，格式类似'2020-02-02'，当前支持查询90天内数据
     */
    @JsonProperty("endDateString")
    private String endDateString;

    /**
     * entityId的维度(当前只支持0-广告主，1-计划，2-单元维度),例如根据单元查询资源位的分级数据，entityId传单元id，entityDimensionType传单元维度，queryDimensionType传资源位维度
     */
    @JsonProperty("entityDimensionType")
    private Integer entityDimensionType;

    /**
     * 各维度查询的主体id，查询计划维度传计划id，查询单元维度传单元id
     */
    @JsonProperty("entityId")
    private Long entityId;

    /**
     * 额外的查询条件，entityDimensionType维度为单元时，须加上父级计划id（planId）的信息
     */
    @JsonProperty("externalParamMap")
    private Map<String, String> externalParamMap;

    /**
     * 排序规则，0-曝光，1-点击，2-点击率，3-cpc,4-花费，5-订单量,6-gmv，7-roi,8-日期，9-cpm,10-店铺收藏，11-商品收藏
     */
    @JsonProperty("orderBy")
    private Integer orderBy;

    /**
     * 排序顺序，0-降序，1-升序
     */
    @JsonProperty("orderType")
    private Integer orderType;

    /**
     * 查询维度，0-广告主，1-计划，2-单元，3-定向，4-创意，5-资源位，6-关键词
     */
    @JsonProperty("queryDimensionType")
    private Integer queryDimensionType;

    /**
     * 分页字段,不传不分页
     */
    @JsonProperty("queryRange")
    private QueryRange queryRange;

    /**
     * 场景类型。0表示搜索，1明星店铺，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    /**
     * 开始日期的字符串，格式类似'2020-02-02'，如果查询今日，startDateString和endDateString传今日的字符串，如果查询历史，startDateString和endDateString分别传开始和结束字符串，不能跨今日和历史查询
     */
    @JsonProperty("startDateString")
    private String startDateString;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.report.entity.report.query";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiReportEntityReportQueryResponse> getResponseClass() {
        return PddAdApiReportEntityReportQueryResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "endDateString", endDateString);
        setUserParam(params, "entityDimensionType", entityDimensionType);
        setUserParam(params, "entityId", entityId);
        setUserParam(params, "externalParamMap", externalParamMap);
        setUserParam(params, "orderBy", orderBy);
        setUserParam(params, "orderType", orderType);
        setUserParam(params, "queryDimensionType", queryDimensionType);
        setUserParam(params, "queryRange", queryRange);
        setUserParam(params, "scenesType", scenesType);
        setUserParam(params, "startDateString", startDateString);
    }

    public void setEndDateString(String endDateString) {
        this.endDateString = endDateString;
    }

    public void setEntityDimensionType(Integer entityDimensionType) {
        this.entityDimensionType = entityDimensionType;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setExternalParamMap(Map<String, String> externalParamMap) {
        this.externalParamMap = externalParamMap;
    }

    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public void setQueryDimensionType(Integer queryDimensionType) {
        this.queryDimensionType = queryDimensionType;
    }

    public void setQueryRange(QueryRange queryRange) {
        this.queryRange = queryRange;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }

    public void setStartDateString(String startDateString) {
        this.startDateString = startDateString;
    }

    public static class QueryRange {

        /**
         * 页数
         */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /**
         * 每页的数量
         */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}