package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiReportHourlyReportQueryResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiReportHourlyReportQueryRequest extends PopBaseHttpRequest<PddAdApiReportHourlyReportQueryResponse> {

    /**
     * 查询日期的字符串，格式类似'2020-02-02',当前支持查询30天内数据
     */
    @JsonProperty("dateString")
    private String dateString;

    /**
     * 各维度查询的主体id，查询计划维度传计划id，查询单元维度传单元id
     */
    @JsonProperty("entityId")
    private Long entityId;

    /**
     * 查询维度，0-广告主，1-计划，2-单元,当前只支持到单元维度
     */
    @JsonProperty("queryDimensionType")
    private Integer queryDimensionType;

    /**
     * 场景类型。0表示搜索，1明星店铺，2表示展示。
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.report.hourly.report.query";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiReportHourlyReportQueryResponse> getResponseClass() {
        return PddAdApiReportHourlyReportQueryResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "dateString", dateString);
        setUserParam(params, "entityId", entityId);
        setUserParam(params, "queryDimensionType", queryDimensionType);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setQueryDimensionType(Integer queryDimensionType) {
        this.queryDimensionType = queryDimensionType;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }
}