package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitBidDeleteResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitBidDeleteRequest extends PopBaseHttpRequest<PddAdApiUnitBidDeleteResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 出价Id列表
     */
    @JsonProperty("bidIds")
    private List<Long> bidIds;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.bid.delete";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitBidDeleteResponse> getResponseClass() {
        return PddAdApiUnitBidDeleteResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "bidIds", bidIds);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setBidIds(List<Long> bidIds) {
        this.bidIds = bidIds;
    }
}