package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitBidQueryBaseTargetProfileResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiUnitBidQueryBaseTargetProfileRequest extends PopBaseHttpRequest<PddAdApiUnitBidQueryBaseTargetProfileResponse> {

    /**
     * 商品Id
     */
    @JsonProperty("goodsId")
    private Long goodsId;

    /**
     * 场景类型，0-搜索，2-展示
     */
    @JsonProperty("scenesType")
    private Integer scenesType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.bid.query.base.target.profile";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitBidQueryBaseTargetProfileResponse> getResponseClass() {
        return PddAdApiUnitBidQueryBaseTargetProfileResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "goodsId", goodsId);
        setUserParam(params, "scenesType", scenesType);
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public void setScenesType(Integer scenesType) {
        this.scenesType = scenesType;
    }
}