package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitBidQueryListResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiUnitBidQueryListRequest extends PopBaseHttpRequest<PddAdApiUnitBidQueryListResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 报表数据开始日期
     */
    @JsonProperty("beginDate")
    private String beginDate;

    /**
     * 出价资源类型。1表示人群定向，2表示资源位。
     */
    @JsonProperty("bidReferenceType")
    private Integer bidReferenceType;

    /**
     * 报表数据截止日期
     */
    @JsonProperty("endDate")
    private String endDate;

    /**
     * 排序字段。0表示按曝光量排序，1表示按点击量排序，2表示按点击率排序，3表示按点击单价排序，4表示按消耗排序，5表示按订单数排序，6表示按交易额排序，7表示按产出比排序，8表示按日期排序，9表示按千次曝光单价排序，10表示按店铺收藏数排序，11表示按商品收藏数排序，12表示按点击转化率排序，13表示按转化成本排序，14表示按平均成交金额排序。
     */
    @JsonProperty("orderBy")
    private Integer orderBy;

    /**
     * 排序类型。0表示降序，1表示升序。
     */
    @JsonProperty("sortBy")
    private Integer sortBy;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.bid.query.list";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitBidQueryListResponse> getResponseClass() {
        return PddAdApiUnitBidQueryListResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "beginDate", beginDate);
        setUserParam(params, "bidReferenceType", bidReferenceType);
        setUserParam(params, "endDate", endDate);
        setUserParam(params, "orderBy", orderBy);
        setUserParam(params, "sortBy", sortBy);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public void setBidReferenceType(Integer bidReferenceType) {
        this.bidReferenceType = bidReferenceType;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }

    public void setSortBy(Integer sortBy) {
        this.sortBy = sortBy;
    }
}