package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitBidSyncResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitBidSyncRequest extends PopBaseHttpRequest<PddAdApiUnitBidSyncResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 出价信息列表
     */
    @JsonProperty("adUnitBids")
    private List<AdUnitBidsItem> adUnitBids;

    /**
     * 出价资源类型。1表示人群定向，2表示资源位。
     */
    @JsonProperty("bidReferenceType")
    private Integer bidReferenceType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.bid.sync";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitBidSyncResponse> getResponseClass() {
        return PddAdApiUnitBidSyncResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "adUnitBids", adUnitBids);
        setUserParam(params, "bidReferenceType", bidReferenceType);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setAdUnitBids(List<AdUnitBidsItem> adUnitBids) {
        this.adUnitBids = adUnitBids;
    }

    public void setBidReferenceType(Integer bidReferenceType) {
        this.bidReferenceType = bidReferenceType;
    }

    public static class AdUnitBidsItem {

        /**
         * 定向信息。仅支持地域定向。
         */
        @JsonProperty("adTargetingVO")
        private AdUnitBidsItemAdTargetingVO adTargetingVO;

        /**
         * 可选人群定向类型或者可选资源位定向类型。人群定向类型，可用枚举值，参考接口：pdd.ad.api.unit.bid.query.base.target.profile资源位定向类型，可用枚举值，参考接口：pdd.ad.api.unit.bid.query.available.location
         */
        @JsonProperty("bidReferenceId")
        private Long bidReferenceId;

        /**
         * 出价，万分比，10000表示100%
         */
        @JsonProperty("bidValue")
        private Long bidValue;

        /**
         * 二级定向Id。默认为0。
         */
        @JsonProperty("subBidReferenceId")
        private Long subBidReferenceId;

        public void setAdTargetingVO(AdUnitBidsItemAdTargetingVO adTargetingVO) {
            this.adTargetingVO = adTargetingVO;
        }

        public void setBidReferenceId(Long bidReferenceId) {
            this.bidReferenceId = bidReferenceId;
        }

        public void setBidValue(Long bidValue) {
            this.bidValue = bidValue;
        }

        public void setSubBidReferenceId(Long subBidReferenceId) {
            this.subBidReferenceId = subBidReferenceId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitBidsItemAdTargetingVO {

        /**
         * 定向集合
         */
        @JsonProperty("adTargetingSet")
        private AdUnitBidsItemAdTargetingVOAdTargetingSet adTargetingSet;

        /**
         * 定向名称
         */
        @JsonProperty("targetingName")
        private String targetingName;

        public void setAdTargetingSet(AdUnitBidsItemAdTargetingVOAdTargetingSet adTargetingSet) {
            this.adTargetingSet = adTargetingSet;
        }

        public void setTargetingName(String targetingName) {
            this.targetingName = targetingName;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitBidsItemAdTargetingVOAdTargetingSet {

        /**
         * 地域定向
         */
        @JsonProperty("areaStruct")
        private AdUnitBidsItemAdTargetingVOAdTargetingSetAreaStruct areaStruct;

        public void setAreaStruct(AdUnitBidsItemAdTargetingVOAdTargetingSetAreaStruct areaStruct) {
            this.areaStruct = areaStruct;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdUnitBidsItemAdTargetingVOAdTargetingSetAreaStruct {

        /**
         * 地域Id列表。具体地域Id编码参见接口返回：pdd.ad.api.unit.bid.query.targeting.tag.list
         */
        @JsonProperty("areaIds")
        private List<Integer> areaIds;

        public void setAreaIds(List<Integer> areaIds) {
            this.areaIds = areaIds;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}