package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitBidUpdateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitBidUpdateRequest extends PopBaseHttpRequest<PddAdApiUnitBidUpdateResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 更新列表
     */
    @JsonProperty("adUnitBids")
    private List<AdUnitBidsItem> adUnitBids;

    /**
     * 出价资源类型。1表示人群定向，2表示资源位。
     */
    @JsonProperty("bidReferenceType")
    private Integer bidReferenceType;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.bid.update";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitBidUpdateResponse> getResponseClass() {
        return PddAdApiUnitBidUpdateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "adUnitBids", adUnitBids);
        setUserParam(params, "bidReferenceType", bidReferenceType);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setAdUnitBids(List<AdUnitBidsItem> adUnitBids) {
        this.adUnitBids = adUnitBids;
    }

    public void setBidReferenceType(Integer bidReferenceType) {
        this.bidReferenceType = bidReferenceType;
    }

    public static class AdUnitBidsItem {

        /**
         * 出价Id
         */
        @JsonProperty("bidId")
        private Long bidId;

        /**
         * 出价，万分比
         */
        @JsonProperty("bidValue")
        private Long bidValue;

        public void setBidId(Long bidId) {
            this.bidId = bidId;
        }

        public void setBidValue(Long bidValue) {
            this.bidValue = bidValue;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}