package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeCreateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitCreativeCreateRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeCreateResponse> {

    /**
     * 创意列表
     */
    @JsonProperty("adCreativeCreateMessage")
    private AdCreativeCreateMessage adCreativeCreateMessage;

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.create";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeCreateResponse> getResponseClass() {
        return PddAdApiUnitCreativeCreateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adCreativeCreateMessage", adCreativeCreateMessage);
        setUserParam(params, "adId", adId);
    }

    public void setAdCreativeCreateMessage(AdCreativeCreateMessage adCreativeCreateMessage) {
        this.adCreativeCreateMessage = adCreativeCreateMessage;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public static class AdCreativeCreateMessage {

        /**
         * 创意图片列表
         */
        @JsonProperty("adImageVOList")
        private List<AdCreativeCreateMessageAdImageVOListItem> adImageVOList;

        /**
         * 创意标题列表
         */
        @JsonProperty("adTextVOList")
        private List<AdCreativeCreateMessageAdTextVOListItem> adTextVOList;

        /**
         * 创意规格，6：商品轮播图，7：商品长图，其余规格暂不支持
         */
        @JsonProperty("creativeSpecificationId")
        private Long creativeSpecificationId;

        public void setAdImageVOList(List<AdCreativeCreateMessageAdImageVOListItem> adImageVOList) {
            this.adImageVOList = adImageVOList;
        }

        public void setAdTextVOList(List<AdCreativeCreateMessageAdTextVOListItem> adTextVOList) {
            this.adTextVOList = adTextVOList;
        }

        public void setCreativeSpecificationId(Long creativeSpecificationId) {
            this.creativeSpecificationId = creativeSpecificationId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdCreativeCreateMessageAdImageVOListItem {

        /**
         * 图片链接，可用图片参考以下接口返回：pdd.ad.api.goods.query.gallery.images（轮播图），pdd.ad.api.goods.query.long.images（长图）
         */
        @JsonProperty("imageUrl")
        private String imageUrl;

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdCreativeCreateMessageAdTextVOListItem {

        /**
         * 标题
         */
        @JsonProperty("text")
        private String text;

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}