package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeDeleteResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiUnitCreativeDeleteRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeDeleteResponse> {

    /**
     * 创意单元Id
     */
    @JsonProperty("unitCreativeId")
    private Long unitCreativeId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.delete";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeDeleteResponse> getResponseClass() {
        return PddAdApiUnitCreativeDeleteResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "unitCreativeId", unitCreativeId);
    }

    public void setUnitCreativeId(Long unitCreativeId) {
        this.unitCreativeId = unitCreativeId;
    }
}