package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeDistributeFlowRateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiUnitCreativeDistributeFlowRateRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeDistributeFlowRateResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 流量分配比例。万分比
     */
    @JsonProperty("creativeFlowRate")
    private Integer creativeFlowRate;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.distribute.flow.rate";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeDistributeFlowRateResponse> getResponseClass() {
        return PddAdApiUnitCreativeDistributeFlowRateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "creativeFlowRate", creativeFlowRate);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setCreativeFlowRate(Integer creativeFlowRate) {
        this.creativeFlowRate = creativeFlowRate;
    }
}