package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeQueryFlowRateResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.Map;

public class PddAdApiUnitCreativeQueryFlowRateRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeQueryFlowRateResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.query.flow.rate";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeQueryFlowRateResponse> getResponseClass() {
        return PddAdApiUnitCreativeQueryFlowRateResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }
}