package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeUpdateContentResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitCreativeUpdateContentRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeUpdateContentResponse> {

    /**
     * 创意更新输入
     */
    @JsonProperty("adCreativeUpdateMessage")
    private AdCreativeUpdateMessage adCreativeUpdateMessage;

    /**
     * 创意单元Id
     */
    @JsonProperty("unitCreativeId")
    private Long unitCreativeId;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.update.content";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeUpdateContentResponse> getResponseClass() {
        return PddAdApiUnitCreativeUpdateContentResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adCreativeUpdateMessage", adCreativeUpdateMessage);
        setUserParam(params, "unitCreativeId", unitCreativeId);
    }

    public void setAdCreativeUpdateMessage(AdCreativeUpdateMessage adCreativeUpdateMessage) {
        this.adCreativeUpdateMessage = adCreativeUpdateMessage;
    }

    public void setUnitCreativeId(Long unitCreativeId) {
        this.unitCreativeId = unitCreativeId;
    }

    public static class AdCreativeUpdateMessage {

        /**
         * 创意图片列表
         */
        @JsonProperty("adImageVOList")
        private List<AdCreativeUpdateMessageAdImageVOListItem> adImageVOList;

        /**
         * 创意标题列表
         */
        @JsonProperty("adTextVOList")
        private List<AdCreativeUpdateMessageAdTextVOListItem> adTextVOList;

        /**
         * 创意规格Id，6-轮播图，7-长图
         */
        @JsonProperty("creativeSpecificationId")
        private Long creativeSpecificationId;

        public void setAdImageVOList(List<AdCreativeUpdateMessageAdImageVOListItem> adImageVOList) {
            this.adImageVOList = adImageVOList;
        }

        public void setAdTextVOList(List<AdCreativeUpdateMessageAdTextVOListItem> adTextVOList) {
            this.adTextVOList = adTextVOList;
        }

        public void setCreativeSpecificationId(Long creativeSpecificationId) {
            this.creativeSpecificationId = creativeSpecificationId;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdCreativeUpdateMessageAdImageVOListItem {

        /**
         * 图片链接，可用图片参考以下接口返回：pdd.ad.api.goods.query.gallery.images（轮播图），pdd.ad.api.goods.query.long.images（长图）
         */
        @JsonProperty("imageUrl")
        private String imageUrl;

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class AdCreativeUpdateMessageAdTextVOListItem {

        /**
         * 标题文字
         */
        @JsonProperty("text")
        private String text;

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}