package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitCreativeUpdateDataOperateStatusResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitCreativeUpdateDataOperateStatusRequest extends PopBaseHttpRequest<PddAdApiUnitCreativeUpdateDataOperateStatusResponse> {

    /**
     * 数据操作状态。1表示开启，2表示暂停。
     */
    @JsonProperty("dataOperateStatus")
    private Integer dataOperateStatus;

    /**
     * 创意单元Id列表
     */
    @JsonProperty("unitCreativeIds")
    private List<Long> unitCreativeIds;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.creative.update.data.operate.status";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitCreativeUpdateDataOperateStatusResponse> getResponseClass() {
        return PddAdApiUnitCreativeUpdateDataOperateStatusResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "dataOperateStatus", dataOperateStatus);
        setUserParam(params, "unitCreativeIds", unitCreativeIds);
    }

    public void setDataOperateStatus(Integer dataOperateStatus) {
        this.dataOperateStatus = dataOperateStatus;
    }

    public void setUnitCreativeIds(List<Long> unitCreativeIds) {
        this.unitCreativeIds = unitCreativeIds;
    }
}