package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitUpdateDataOperateStatusResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitUpdateDataOperateStatusRequest extends PopBaseHttpRequest<PddAdApiUnitUpdateDataOperateStatusResponse> {

    /**
     * 广告单元Id列表。一次不得超过20个。
     */
    @JsonProperty("adIds")
    private List<Long> adIds;

    /**
     * 数据操作状态。1表示开启，2表示暂停。
     */
    @JsonProperty("dataOperateStatus")
    private Integer dataOperateStatus;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.update.data.operate.status";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitUpdateDataOperateStatusResponse> getResponseClass() {
        return PddAdApiUnitUpdateDataOperateStatusResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adIds", adIds);
        setUserParam(params, "dataOperateStatus", dataOperateStatus);
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public void setDataOperateStatus(Integer dataOperateStatus) {
        this.dataOperateStatus = dataOperateStatus;
    }
}