package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddAdApiUnitUpdateOptimizationMessageResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddAdApiUnitUpdateOptimizationMessageRequest extends PopBaseHttpRequest<PddAdApiUnitUpdateOptimizationMessageResponse> {

    /**
     * 广告单元Id
     */
    @JsonProperty("adId")
    private Long adId;

    /**
     * 优化信息
     */
    @JsonProperty("optimizationMessage")
    private OptimizationMessage optimizationMessage;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.ad.api.unit.update.optimization.message";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddAdApiUnitUpdateOptimizationMessageResponse> getResponseClass() {
        return PddAdApiUnitUpdateOptimizationMessageResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "adId", adId);
        setUserParam(params, "optimizationMessage", optimizationMessage);
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public void setOptimizationMessage(OptimizationMessage optimizationMessage) {
        this.optimizationMessage = optimizationMessage;
    }

    public static class OptimizationMessage {

        /**
         * 数据积累期出价。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("accumulationBid")
        private Long accumulationBid;

        /**
         * 智能投放期出价。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 优化目标。0表示不优化。1表示优化ROI，2表示优化转化成本。当计划使用智能推广时，该值必须传1；当单元使用自动调价功能(ECPC)时，该值必须传1；当单元使用OCPC功能时，该值必须传2。
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        /**
         * 优化方式。0表示不优化，1表示ECPC，2表示OCPC。当计划使用智能推广时，该值必须传0；当单元使用ECPC时，该值必须传1；当使用OCPC时，该值必须传2。
         */
        @JsonProperty("optimizationMethod")
        private Integer optimizationMethod;

        /**
         * 可选优化出价列表。当使用OCPX时对该字段赋值。
         */
        @JsonProperty("optionalOptimizationBidMessageList")
        private List<OptimizationMessageOptionalOptimizationBidMessageListItem> optionalOptimizationBidMessageList;

        public void setAccumulationBid(Long accumulationBid) {
            this.accumulationBid = accumulationBid;
        }

        public void setOptimizationBid(Long optimizationBid) {
            this.optimizationBid = optimizationBid;
        }

        public void setOptimizationGoal(Integer optimizationGoal) {
            this.optimizationGoal = optimizationGoal;
        }

        public void setOptimizationMethod(Integer optimizationMethod) {
            this.optimizationMethod = optimizationMethod;
        }

        public void setOptionalOptimizationBidMessageList(List<OptimizationMessageOptionalOptimizationBidMessageListItem> optionalOptimizationBidMessageList) {
            this.optionalOptimizationBidMessageList = optionalOptimizationBidMessageList;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }

    public static class OptimizationMessageOptionalOptimizationBidMessageListItem {

        /**
         * 可选优化出价价格
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 可选优化出价目标。3表示优化店铺关注，4表示优化商品收藏，5表示优化询单
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        public void setOptimizationBid(Long optimizationBid) {
            this.optimizationBid = optimizationBid;
        }

        public void setOptimizationGoal(Integer optimizationGoal) {
            this.optimizationGoal = optimizationGoal;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}