package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddLogisticsTicketNotifyResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddLogisticsTicketNotifyRequest extends PopBaseHttpRequest<PddLogisticsTicketNotifyResponse> {

    /**
     * 附件url,示例：["http: testimg.yangkeduo.com/pdd_oms/2018-01-16/411068e948835ae053a86c13f8ebb5ee.jpg"]
     */
    @JsonProperty("attach_path_list")
    private List<String> attachPathList;

    /**
     * 工单id
     */
    @JsonProperty("ticket_id")
    private Long ticketId;

    /**
     * 运单号
     */
    @JsonProperty("waybill_no")
    private String waybillNo;

    /**
     * 处理结果
     */
    @JsonProperty("handle_result")
    private String handleResult;

    /**
     * 签收状态，0:默认,1:未签收,2:已签收
     */
    @JsonProperty("sign_state")
    private Integer signState;

    /**
     * 是否赔付，0:默认,1:未赔付,2:已赔付
     */
    @JsonProperty("compensate_state")
    private Integer compensateState;

    /**
     * 赔付金额(单位:分)
     */
    @JsonProperty("compensate_amount")
    private Long compensateAmount;

    /**
     * 责任方，0:默认, 1:消费者,2:商家,3:快递公司,4:其他
     */
    @JsonProperty("duty")
    private Integer duty;

    /**
     * 处理人
     */
    @JsonProperty("express_dealer")
    private String expressDealer;

    /**
     * 处理人联系方式
     */
    @JsonProperty("express_dealer_contact")
    private String expressDealerContact;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.logistics.ticket.notify";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddLogisticsTicketNotifyResponse> getResponseClass() {
        return PddLogisticsTicketNotifyResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "attach_path_list", attachPathList);
        setUserParam(params, "ticket_id", ticketId);
        setUserParam(params, "waybill_no", waybillNo);
        setUserParam(params, "handle_result", handleResult);
        setUserParam(params, "sign_state", signState);
        setUserParam(params, "compensate_state", compensateState);
        setUserParam(params, "compensate_amount", compensateAmount);
        setUserParam(params, "duty", duty);
        setUserParam(params, "express_dealer", expressDealer);
        setUserParam(params, "express_dealer_contact", expressDealerContact);
    }

    public void setAttachPathList(List<String> attachPathList) {
        this.attachPathList = attachPathList;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public void setWaybillNo(String waybillNo) {
        this.waybillNo = waybillNo;
    }

    public void setHandleResult(String handleResult) {
        this.handleResult = handleResult;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }

    public void setCompensateState(Integer compensateState) {
        this.compensateState = compensateState;
    }

    public void setCompensateAmount(Long compensateAmount) {
        this.compensateAmount = compensateAmount;
    }

    public void setDuty(Integer duty) {
        this.duty = duty;
    }

    public void setExpressDealer(String expressDealer) {
        this.expressDealer = expressDealer;
    }

    public void setExpressDealerContact(String expressDealerContact) {
        this.expressDealerContact = expressDealerContact;
    }
}