package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddOpenKmsSearchBatchResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddOpenKmsSearchBatchRequest extends PopBaseHttpRequest<PddOpenKmsSearchBatchResponse> {

    /**
     * 数据列表, 列表大小不超过100
     */
    @JsonProperty("input_list")
    private List<InputListItem> inputList;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.open.kms.search.batch";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddOpenKmsSearchBatchResponse> getResponseClass() {
        return PddOpenKmsSearchBatchResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "input_list", inputList);
    }

    public void setInputList(List<InputListItem> inputList) {
        this.inputList = inputList;
    }

    public static class InputListItem {

        /**
         * 搜索内容
         */
        @JsonProperty("input")
        private String input;

        /**
         * 敏感信息类型. id: 身份证号, phone: 手机号码, simple: 昵称, 地址等
         */
        @JsonProperty("type")
        private String type;

        public void setInput(String input) {
            this.input = input;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}