package com.pdd.pop.sdk.http.api.pop.request;

import com.pdd.pop.sdk.common.util.JsonUtil;
import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.api.pop.response.PddVoucherPhysicalGoodsSendResponse;
import com.pdd.pop.sdk.http.HttpMethod;
import com.pdd.pop.sdk.http.PopBaseHttpRequest;

import java.util.List;
import java.util.Map;

public class PddVoucherPhysicalGoodsSendRequest extends PopBaseHttpRequest<PddVoucherPhysicalGoodsSendResponse> {

    /**
     * 订单号
     */
    @JsonProperty("order_sn")
    private String orderSn;

    /**
     * 外部流水号
     */
    @JsonProperty("out_biz_no")
    private String outBizNo;

    /**
     * 优惠券信息列表,例子[{"voucher_id":"test voucher_id","voucher_no":"test voucher_no"}]
     */
    @JsonProperty("voucher_list")
    private List<VoucherListItem> voucherList;

    /**
     * 物流方式  1  物流发货   2 自提
     */
    @JsonProperty("logistics_type")
    private Integer logisticsType;

    /**
     * 收件人
     */
    @JsonProperty("recipient")
    private String recipient;

    /**
     * 收件人电话
     */
    @JsonProperty("recipient_mobile")
    private String recipientMobile;

    /**
     * 收件人地址
     */
    @JsonProperty("recipient_address")
    private String recipientAddress;

    /**
     * 物流单号
     */
    @JsonProperty("logistics_no")
    private String logisticsNo;

    /**
     * 物流公司编号
     */
    @JsonProperty("logistics_company_id")
    private String logisticsCompanyId;

    /**
     * 物流公司名称
     */
    @JsonProperty("logistics_company")
    private String logisticsCompany;

    @Override
    public String getVersion() {
        return "V1";
    }

    @Override
    public String getDataType() {
        return "JSON";
    }

    @Override
    public Integer getPlatform() {
        return 0;
    }

    @Override
    public String getType() {
        return "pdd.voucher.physical.goods.send";
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public Class<PddVoucherPhysicalGoodsSendResponse> getResponseClass() {
        return PddVoucherPhysicalGoodsSendResponse.class;
    }

    @Override
    protected void setUserParams(Map<String, String> params) {
        setUserParam(params, "order_sn", orderSn);
        setUserParam(params, "out_biz_no", outBizNo);
        setUserParam(params, "voucher_list", voucherList);
        setUserParam(params, "logistics_type", logisticsType);
        setUserParam(params, "recipient", recipient);
        setUserParam(params, "recipient_mobile", recipientMobile);
        setUserParam(params, "recipient_address", recipientAddress);
        setUserParam(params, "logistics_no", logisticsNo);
        setUserParam(params, "logistics_company_id", logisticsCompanyId);
        setUserParam(params, "logistics_company", logisticsCompany);
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public void setOutBizNo(String outBizNo) {
        this.outBizNo = outBizNo;
    }

    public void setVoucherList(List<VoucherListItem> voucherList) {
        this.voucherList = voucherList;
    }

    public void setLogisticsType(Integer logisticsType) {
        this.logisticsType = logisticsType;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setRecipientMobile(String recipientMobile) {
        this.recipientMobile = recipientMobile;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public void setLogisticsNo(String logisticsNo) {
        this.logisticsNo = logisticsNo;
    }

    public void setLogisticsCompanyId(String logisticsCompanyId) {
        this.logisticsCompanyId = logisticsCompanyId;
    }

    public void setLogisticsCompany(String logisticsCompany) {
        this.logisticsCompany = logisticsCompany;
    }

    public static class VoucherListItem {

        /**
         * 卡券ID
         */
        @JsonProperty("voucher_id")
        private String voucherId;

        /**
         * 卡券号
         */
        @JsonProperty("voucher_no")
        private String voucherNo;

        public void setVoucherId(String voucherId) {
            this.voucherId = voucherId;
        }

        public void setVoucherNo(String voucherNo) {
            this.voucherNo = voucherNo;
        }

        @Override
        public String toString() {
            return JsonUtil.transferToJson(this);
        }
    }
}