package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiAdvertiserQueryAccountBalanceResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private ResponseResult result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public ResponseResult getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResult {

        /**
         * 账户余额明细列表
         */
        @JsonProperty("accountsBalance")
        private List<ResponseResultAccountsBalanceItem> accountsBalance;

        /**
         * 总余额，单位厘
         */
        @JsonProperty("balance")
        private Long balance;

        /**
         * 广告主Id
         */
        @JsonProperty("mallId")
        private Long mallId;

        public List<ResponseResultAccountsBalanceItem> getAccountsBalance() {
            return accountsBalance;
        }

        public Long getBalance() {
            return balance;
        }

        public Long getMallId() {
            return mallId;
        }
    }

    public static class ResponseResultAccountsBalanceItem {

        /**
         * 账户类型。1表示现金余额，2表示通用红包余额，3表示奖励金余额，7表示聚焦展位CPM专用红包余额，10表示直播专用红包余额。
         */
        @JsonProperty("accountType")
        private Integer accountType;

        /**
         * 账户余额，单位厘
         */
        @JsonProperty("rawBalance")
        private Long rawBalance;

        /**
         * 可消费余额，单位厘
         */
        @JsonProperty("spendableBalance")
        private Long spendableBalance;

        public Integer getAccountType() {
            return accountType;
        }

        public Long getRawBalance() {
            return rawBalance;
        }

        public Long getSpendableBalance() {
            return spendableBalance;
        }
    }
}