package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;




public class PddAdApiAdvertiserQueryDetailResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("error_code")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("error_msg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private ResponseResult result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public ResponseResult getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResult {

        /**
         * 广告主审核状态。1表示审核通过，2表示待审核，3表示审核拒绝，4表示复审拒绝。
         */
        @JsonProperty("advertiser_audit_status")
        private Integer advertiserAuditStatus;

        /**
         * 惩罚信息
         */
        @JsonProperty("advertiser_punish_detail")
        private ResponseResultAdvertiserPunishDetail advertiserPunishDetail;

        /**
         * 广告主审核原因
         */
        @JsonProperty("audit_reason")
        private Integer auditReason;

        /**
         * 
         */
        @JsonProperty("mall_Id")
        private Long mallId;

        public Integer getAdvertiserAuditStatus() {
            return advertiserAuditStatus;
        }

        public ResponseResultAdvertiserPunishDetail getAdvertiserPunishDetail() {
            return advertiserPunishDetail;
        }

        public Integer getAuditReason() {
            return auditReason;
        }

        public Long getMallId() {
            return mallId;
        }
    }

    public static class ResponseResultAdvertiserPunishDetail {

        /**
         * 惩罚原因
         */
        @JsonProperty("punish_reason")
        private String punishReason;

        /**
         * 惩罚状态。1表示正常，2表示惩罚中。
         */
        @JsonProperty("punish_status")
        private Integer punishStatus;

        public String getPunishReason() {
            return punishReason;
        }

        public Integer getPunishStatus() {
            return punishStatus;
        }
    }
}