package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiPlanQueryListResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private List<ResponseResultItem> result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public List<ResponseResultItem> getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResultItem {

        /**
         * 计划日限额今日剩余可修改次数。一个计划一天可修改五次日限额。
         */
        @JsonProperty("availableBudgetChangeNumberToday")
        private Integer availableBudgetChangeNumberToday;

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 计划日限额今日已修改次数
         */
        @JsonProperty("budgetChangedNumberToday")
        private Integer budgetChangedNumberToday;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 分时折扣比例。千分比。
         */
        @JsonProperty("discountRate")
        private Integer discountRate;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺关注数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 日消耗上限。单位厘
         */
        @JsonProperty("maxCost")
        private Long maxCost;

        /**
         * 广告主账户状态。1表示余额充足，2表示余额不足，3表示超出消耗上限。
         */
        @JsonProperty("merchantAccountStatus")
        private Integer merchantAccountStatus;

        /**
         * 操作状态。1表示开启，2表示暂停。
         */
        @JsonProperty("merchantOperateStatus")
        private Integer merchantOperateStatus;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 计划ID
         */
        @JsonProperty("planId")
        private Long planId;

        /**
         * 计划名称
         */
        @JsonProperty("planName")
        private String planName;

        /**
         * 推广策略。1表示自定义推广，2表示智能推广。
         */
        @JsonProperty("planStrategy")
        private Integer planStrategy;

        /**
         * 广告惩罚原因
         */
        @JsonProperty("punishReason")
        private String punishReason;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗,单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 单元状态。1表示推广中，2表示手动暂停，3表示余额不足，4表示到达日限额，5表示无推广中单元，6表示已删除，7表示系统暂停-投放已结束，8表示系统暂停-投放未开始，9表示不在投放时段，10表示待确认推广单，11表示推广费用待锁定，12表示合约已失效，13表示限制推广，14表示部分推广中，15表示店铺限制推广。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        /**
         * 计划下的单元数量
         */
        @JsonProperty("unitNum")
        private Integer unitNum;

        public Integer getAvailableBudgetChangeNumberToday() {
            return availableBudgetChangeNumberToday;
        }

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Integer getBudgetChangedNumberToday() {
            return budgetChangedNumberToday;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public Integer getDiscountRate() {
            return discountRate;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getMaxCost() {
            return maxCost;
        }

        public Integer getMerchantAccountStatus() {
            return merchantAccountStatus;
        }

        public Integer getMerchantOperateStatus() {
            return merchantOperateStatus;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Long getPlanId() {
            return planId;
        }

        public String getPlanName() {
            return planName;
        }

        public Integer getPlanStrategy() {
            return planStrategy;
        }

        public String getPunishReason() {
            return punishReason;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public Integer getStatus() {
            return status;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }

        public Integer getUnitNum() {
            return unitNum;
        }
    }
}